/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.randomtrees;

import ai.libs.jaicore.search.exampleproblems.randomtrees.RandomTreeGoalTester;
import ai.libs.jaicore.search.exampleproblems.randomtrees.RandomTreeGraphGenerator;
import java.util.List;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;

public class RandomTreeSearchProblem
implements IPathSearchWithPathEvaluationsInput<List<Integer>, Integer, Double> {
    private final int b;
    private final int d;
    private final long seed;
    private final IGraphGenerator<List<Integer>, Integer> gg;
    private final IPathGoalTester<List<Integer>, Integer> gt;
    private final IPathEvaluator<List<Integer>, Integer, Double> se;
    private final boolean scoresPerEdge;

    public RandomTreeSearchProblem(int b, int d, long seed, int maxPerDepth, boolean scoresPerEdge) {
        this.b = b;
        this.d = d;
        this.seed = seed;
        this.gg = new RandomTreeGraphGenerator(b, d, seed, maxPerDepth);
        this.gt = new RandomTreeGoalTester(d);
        this.scoresPerEdge = scoresPerEdge;
        this.se = n -> scoresPerEdge ? (double)((Integer)((List)n.getHead()).stream().reduce((current, added) -> current + added).get()).intValue() / (double)(d * maxPerDepth) : (double)((Integer)((List)n.getHead()).get(((List)n.getHead()).size() - 1)).intValue();
    }

    public IGraphGenerator<List<Integer>, Integer> getGraphGenerator() {
        return this.gg;
    }

    public IPathGoalTester<List<Integer>, Integer> getGoalTester() {
        return this.gt;
    }

    public IPathEvaluator<List<Integer>, Integer, Double> getPathEvaluator() {
        return this.se;
    }

    public int getB() {
        return this.b;
    }

    public int getD() {
        return this.d;
    }

    public IGraphGenerator<List<Integer>, Integer> getGg() {
        return this.gg;
    }

    public IPathGoalTester<List<Integer>, Integer> getGt() {
        return this.gt;
    }

    public IPathEvaluator<List<Integer>, Integer, Double> getSe() {
        return this.se;
    }

    public boolean isScoresPerEdge() {
        return this.scoresPerEdge;
    }

    public long getSeed() {
        return this.seed;
    }
}

