/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.samegame;

import ai.libs.jaicore.problems.samegame.SameGameCell;
import ai.libs.jaicore.problems.samegame.SameGameState;
import ai.libs.jaicore.search.exampleproblems.samegame.SameGameNode;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.datastructure.graph.ILabeledPath;

public class SameGamePathEvaluator
implements IPathEvaluator<SameGameNode, SameGameCell, Double> {
    private final boolean maximize;
    private final int minScore;
    private final int maxScore;
    private final boolean relativeScores;

    public SameGamePathEvaluator(SameGameState initState, boolean maximize, boolean relativeScores) {
        this.minScore = -10000;
        this.maxScore = (int)Math.pow((double)((Integer)initState.getNumberOfPiecesPerColor().values().stream().max(Integer::compare).get()).intValue() - 2.0, 2.0);
        this.relativeScores = relativeScores;
        this.maximize = maximize;
    }

    public Double evaluate(ILabeledPath<SameGameNode, SameGameCell> path) throws PathEvaluationException, InterruptedException {
        double unitVal = ((double)((SameGameNode)path.getHead()).getScore() - (double)this.minScore) / (double)(this.relativeScores ? this.maxScore - this.minScore : 1);
        return this.maximize ? unitVal : 1.0 - unitVal;
    }

    public double getOriginalScoreFromRelativeScore(double relativeScore) {
        double relOriginalScore = this.maximize ? relativeScore : 1.0 - relativeScore;
        return relOriginalScore * (double)(this.maxScore - this.minScore) + (double)this.minScore;
    }

    public boolean isMaximize() {
        return this.maximize;
    }

    public int getMinScore() {
        return this.minScore;
    }

    public int getMaxScore() {
        return this.maxScore;
    }

    public boolean isRelativeScores() {
        return this.relativeScores;
    }
}

