/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.taxi;

import ai.libs.jaicore.basic.sets.IntCoordinates;
import ai.libs.jaicore.search.exampleproblems.taxi.ETaxiAction;
import ai.libs.jaicore.search.exampleproblems.taxi.TaxiState;
import ai.libs.jaicore.search.probleminputs.AMDP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class TaxiMDP
extends AMDP<TaxiState, ETaxiAction, Double> {
    private final boolean[][][] possibleTransitions;
    private final int width;
    private final int height;
    private final double successRate;
    private final List<IntCoordinates> pickupLocations;
    private final IntCoordinates pickupLocation;
    private final IntCoordinates targetLocation;

    private static TaxiState drawInitState(int width, int height, List<IntCoordinates> pickupLocations, Random random) {
        int y;
        int x;
        IntCoordinates coords;
        while (pickupLocations.contains(coords = new IntCoordinates(x = random.nextInt(width), y = random.nextInt(height)))) {
        }
        return new TaxiState(coords, false, false);
    }

    public TaxiMDP(boolean[][][] possibleTransitions, double successRate, List<IntCoordinates> pickupLocations, Random random) {
        super(TaxiMDP.drawInitState(possibleTransitions.length, possibleTransitions[0].length, pickupLocations, random));
        this.width = possibleTransitions.length;
        this.height = possibleTransitions[0].length;
        this.possibleTransitions = possibleTransitions;
        this.successRate = successRate;
        this.pickupLocations = pickupLocations;
        this.pickupLocation = pickupLocations.get(0);
        this.targetLocation = pickupLocations.get(1);
    }

    public boolean[][][] getPossibleTransitions() {
        return this.possibleTransitions;
    }

    public double getSuccessRate() {
        return this.successRate;
    }

    public List<IntCoordinates> getPickupLocations() {
        return this.pickupLocations;
    }

    @Override
    public boolean isMaximizing() {
        return true;
    }

    @Override
    public Collection<ETaxiAction> getApplicableActions(TaxiState state) {
        ArrayList<ETaxiAction> possibleActions = new ArrayList<ETaxiAction>();
        if (state.isPassengerDelivered()) {
            return possibleActions;
        }
        if (state.getPosition().equals((Object)this.pickupLocation) && !state.isPassengerOnBoard()) {
            possibleActions.add(ETaxiAction.PICKUP);
            return possibleActions;
        }
        if (state.getPosition().equals((Object)this.targetLocation) && state.isPassengerOnBoard()) {
            possibleActions.add(ETaxiAction.PUTDOWN);
            return possibleActions;
        }
        for (ETaxiAction a : ETaxiAction.values()) {
            if (a == ETaxiAction.PICKUP || a == ETaxiAction.PUTDOWN || !this.isDirectionPossible(state, a)) continue;
            possibleActions.add(a);
        }
        return possibleActions;
    }

    private boolean isDirectionPossible(TaxiState state, ETaxiAction action) {
        int x = state.getPosition().getX();
        int y = state.getPosition().getY();
        switch (action) {
            case W: {
                return x > 0 && this.possibleTransitions[x][y][3];
            }
            case E: {
                return x < this.width - 1 && this.possibleTransitions[x][y][1];
            }
            case S: {
                return y > 0 && this.possibleTransitions[x][y][2];
            }
            case N: {
                return y < this.height - 1 && this.possibleTransitions[x][y][0];
            }
        }
        throw new IllegalStateException("Invalid direction " + (Object)((Object)action));
    }

    @Override
    public Map<TaxiState, Double> getProb(TaxiState state, ETaxiAction action) {
        HashMap<TaxiState, Double> dist = new HashMap<TaxiState, Double>();
        if (action == ETaxiAction.PICKUP) {
            TaxiState succ = new TaxiState(state.getPosition(), true, false);
            dist.put(succ, 1.0);
            return dist;
        }
        if (action == ETaxiAction.PUTDOWN) {
            TaxiState succ = new TaxiState(state.getPosition(), false, true);
            dist.put(succ, 1.0);
            return dist;
        }
        IntCoordinates pos = state.getPosition();
        boolean lPossible = this.isDirectionPossible(state, ETaxiAction.W);
        boolean rPossible = this.isDirectionPossible(state, ETaxiAction.E);
        boolean tPossible = this.isDirectionPossible(state, ETaxiAction.N);
        boolean bPossible = this.isDirectionPossible(state, ETaxiAction.S);
        boolean isOnBoard = state.isPassengerOnBoard();
        boolean isDelivered = state.isPassengerDelivered();
        if (action == ETaxiAction.N) {
            double prob;
            dist.put(new TaxiState(pos.getUp(), isOnBoard, isDelivered), this.successRate);
            double d = prob = lPossible && rPossible ? (1.0 - this.successRate) / 2.0 : 1.0 - this.successRate;
            if (lPossible) {
                dist.put(new TaxiState(pos.getLeft(), isOnBoard, isDelivered), prob);
            }
            if (rPossible) {
                dist.put(new TaxiState(pos.getRight(), isOnBoard, isDelivered), prob);
            }
        } else if (action == ETaxiAction.E) {
            double prob;
            dist.put(new TaxiState(pos.getRight(), isOnBoard, isDelivered), this.successRate);
            double d = prob = tPossible && bPossible ? (1.0 - this.successRate) / 2.0 : 1.0 - this.successRate;
            if (tPossible) {
                dist.put(new TaxiState(pos.getUp(), isOnBoard, isDelivered), prob);
            }
            if (bPossible) {
                dist.put(new TaxiState(pos.getDown(), isOnBoard, isDelivered), prob);
            }
        } else if (action == ETaxiAction.S) {
            double prob;
            dist.put(new TaxiState(pos.getDown(), isOnBoard, isDelivered), this.successRate);
            double d = prob = lPossible && rPossible ? (1.0 - this.successRate) / 2.0 : 1.0 - this.successRate;
            if (lPossible) {
                dist.put(new TaxiState(pos.getLeft(), isOnBoard, isDelivered), prob);
            }
            if (rPossible) {
                dist.put(new TaxiState(pos.getRight(), isOnBoard, isDelivered), prob);
            }
        } else if (action == ETaxiAction.W) {
            double prob;
            dist.put(new TaxiState(pos.getLeft(), isOnBoard, isDelivered), this.successRate);
            double d = prob = tPossible && bPossible ? (1.0 - this.successRate) / 2.0 : 1.0 - this.successRate;
            if (tPossible) {
                dist.put(new TaxiState(pos.getUp(), isOnBoard, isDelivered), prob);
            }
            if (bPossible) {
                dist.put(new TaxiState(pos.getDown(), isOnBoard, isDelivered), prob);
            }
        } else {
            throw new IllegalArgumentException("Do not know how to process action " + (Object)((Object)action) + " in state " + state);
        }
        return dist;
    }

    @Override
    public Double getScore(TaxiState state, ETaxiAction action, TaxiState successor) {
        if (successor.isPassengerDelivered() && action == ETaxiAction.PUTDOWN) {
            return 0.19;
        }
        return -0.01;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int cols = this.width;
        int rows = this.height;
        int startCol = ((TaxiState)this.getInitState()).getPosition().getX();
        int startRow = ((TaxiState)this.getInitState()).getPosition().getY();
        int pickupCol = this.pickupLocation.getX();
        int pickupRow = this.pickupLocation.getY();
        int targetCol = this.targetLocation.getX();
        int targetRow = this.targetLocation.getY();
        for (int r = rows - 1; r >= 0; --r) {
            int c;
            for (c = 0; c < cols; ++c) {
                sb.append("+-");
            }
            sb.append("+\n");
            for (c = 0; c < cols; ++c) {
                sb.append("|");
                if (c == startCol && r == startRow) {
                    sb.append("x");
                    continue;
                }
                if (targetCol == c && targetRow == r) {
                    sb.append("*");
                    continue;
                }
                if (pickupCol == c && pickupRow == r) {
                    sb.append("o");
                    continue;
                }
                sb.append(" ");
            }
            sb.append("+\n");
        }
        return sb.toString();
    }
}

