/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.experiments;

import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.search.algorithms.mdp.mcts.MCTSFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.brue.BRUEFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.FixedCommitmentMCTSFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.PlackettLuceMCTSFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.preferencekernel.bootstrapping.BootstrappingPreferenceKernel;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.preferencekernel.bootstrapping.DefaultBootsrapConfigurator;
import ai.libs.jaicore.search.algorithms.mdp.mcts.ensemble.EnsembleMCTSFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.spuct.SPUCTFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.tag.TAGMCTSFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.thompson.DNGMCTSFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.thompson.DNGPolicy;
import ai.libs.jaicore.search.algorithms.mdp.mcts.uct.UCBPolicy;
import ai.libs.jaicore.search.algorithms.mdp.mcts.uct.UCTFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.uuct.UUCTFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.uuct.utility.VaR;
import ai.libs.jaicore.search.algorithms.standard.auxilliary.iteratingoptimizer.IteratingGraphSearchOptimizer;
import ai.libs.jaicore.search.algorithms.standard.auxilliary.iteratingoptimizer.IteratingGraphSearchOptimizerFactory;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.BestFirst;
import ai.libs.jaicore.search.algorithms.standard.dfs.DepthFirstSearchFactory;
import ai.libs.jaicore.search.algorithms.standard.mcts.MCTSPathSearch;
import ai.libs.jaicore.search.algorithms.standard.random.RandomSearchFactory;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import ai.libs.jaicore.search.problemtransformers.GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS;
import ai.libs.jaicore.search.problemtransformers.GraphSearchWithPathEvaluationsInputToGraphSearchWithSubpathEvaluationViaUninformedness;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.api4.java.ai.graphsearch.problem.IOptimalPathInORGraphSearch;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IEvaluatedPath;

public class StandardExperimentSearchAlgorithmFactory<N, A, I extends IPathSearchWithPathEvaluationsInput<N, A, Double>> {
    private MCTSPathSearch<I, N, A> getMCTS(I input, MCTSFactory<N, A, ?> factory, int maxiter, int seed) {
        factory.withRandom(new Random(seed));
        factory.withMaxIterations(maxiter);
        return new MCTSPathSearch<I, N, A>(input, factory);
    }

    public IOptimalPathInORGraphSearch<I, ? extends IEvaluatedPath<N, A, Double>, N, A, Double> getAlgorithm(Experiment experiment, IPathSearchWithPathEvaluationsInput<N, A, Double> input) {
        int seed = Integer.parseInt((String)experiment.getValuesOfKeyFields().get("seed"));
        String algorithm = (String)experiment.getValuesOfKeyFields().get("algorithmname");
        int maxiter = Integer.MAX_VALUE;
        if (algorithm.startsWith("uuct-")) {
            String[] parts = algorithm.split("-");
            double alpha = Double.parseDouble(parts[1]);
            double b = Double.parseDouble(parts[2]);
            UUCTFactory uuctFactory = new UUCTFactory();
            uuctFactory.setUtility(new VaR(alpha, b));
            return this.getMCTS(input, uuctFactory, Integer.MAX_VALUE, seed);
        }
        switch (algorithm) {
            case "random": {
                IteratingGraphSearchOptimizerFactory factory = new IteratingGraphSearchOptimizerFactory();
                RandomSearchFactory rsf = new RandomSearchFactory();
                rsf.setSeed(seed);
                factory.setBaseAlgorithmFactory(rsf);
                IteratingGraphSearchOptimizer optimizer = factory.getAlgorithm(input);
                return optimizer;
            }
            case "bf-uninformed": {
                GraphSearchWithPathEvaluationsInputToGraphSearchWithSubpathEvaluationViaUninformedness<N, A> reducer = new GraphSearchWithPathEvaluationsInputToGraphSearchWithSubpathEvaluationViaUninformedness<N, A>();
                GraphSearchWithSubpathEvaluationsInput reducedProblem = reducer.encodeProblem(input);
                return new BestFirst(reducedProblem);
            }
            case "bf-informed": {
                GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS reducer2 = new GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS(n -> null, n -> false, new Random(seed), 3, 30000, 60000);
                return new BestFirst(reducer2.encodeProblem(input));
            }
            case "uct": {
                return this.getMCTS(input, new UCTFactory(), Integer.MAX_VALUE, seed);
            }
            case "ensemble": {
                DNGMCTSFactory dngFactory = new DNGMCTSFactory();
                dngFactory.setInitLambda(0.01);
                DNGPolicy dng001 = (DNGPolicy)this.getMCTS(input, dngFactory, Integer.MAX_VALUE, seed).getMcts().getTreePolicy();
                dngFactory.setInitLambda(0.1);
                DNGPolicy dng01 = (DNGPolicy)this.getMCTS(input, dngFactory, Integer.MAX_VALUE, seed).getMcts().getTreePolicy();
                dngFactory.setInitLambda(1.0);
                DNGPolicy dng1 = (DNGPolicy)this.getMCTS(input, dngFactory, Integer.MAX_VALUE, seed).getMcts().getTreePolicy();
                dngFactory.setInitLambda(10.0);
                DNGPolicy dng10 = (DNGPolicy)this.getMCTS(input, dngFactory, Integer.MAX_VALUE, seed).getMcts().getTreePolicy();
                dngFactory.setInitLambda(100.0);
                DNGPolicy dng100 = (DNGPolicy)this.getMCTS(input, dngFactory, Integer.MAX_VALUE, seed).getMcts().getTreePolicy();
                EnsembleMCTSFactory eFactory = new EnsembleMCTSFactory();
                eFactory.setTreePolicies(Arrays.asList(new UCBPolicy(1.0, true), dng001, dng01, dng1, dng01, dng10, dng100));
                return this.getMCTS(input, eFactory, Integer.MAX_VALUE, seed);
            }
            case "sp-uct": {
                SPUCTFactory spucbFactory = new SPUCTFactory();
                spucbFactory.setBigD(10000.0);
                return this.getMCTS(input, spucbFactory, Integer.MAX_VALUE, seed);
            }
            case "pl-mcts-mean": {
                return this.getMCTS(input, new PlackettLuceMCTSFactory().withPreferenceKernel(new BootstrappingPreferenceKernel(DescriptiveStatistics::getMean, new DefaultBootsrapConfigurator(), 1)), Integer.MAX_VALUE, seed);
            }
            case "pl-mcts-mean+std": {
                return this.getMCTS(input, new PlackettLuceMCTSFactory().withPreferenceKernel(new BootstrappingPreferenceKernel(d -> d.getMean() + d.getStandardDeviation(), new DefaultBootsrapConfigurator(), 1)), Integer.MAX_VALUE, seed);
            }
            case "pl-mcts-mean-std": {
                return this.getMCTS(input, new PlackettLuceMCTSFactory().withPreferenceKernel(new BootstrappingPreferenceKernel(d -> d.getMean() - d.getStandardDeviation(), new DefaultBootsrapConfigurator(), 1)), Integer.MAX_VALUE, seed);
            }
            case "pl-mcts-min": {
                return this.getMCTS(input, new PlackettLuceMCTSFactory().withPreferenceKernel(new BootstrappingPreferenceKernel(DescriptiveStatistics::getMin, new DefaultBootsrapConfigurator(), 1)), Integer.MAX_VALUE, seed);
            }
            case "mcts-kfix-100-mean": {
                FixedCommitmentMCTSFactory fcFactory1 = new FixedCommitmentMCTSFactory();
                fcFactory1.setK(100);
                fcFactory1.setMetric(DescriptiveStatistics::getMean);
                return this.getMCTS(input, fcFactory1, Integer.MAX_VALUE, seed);
            }
            case "mcts-kfix-200-mean": {
                FixedCommitmentMCTSFactory fcFactory2 = new FixedCommitmentMCTSFactory();
                fcFactory2.setK(200);
                fcFactory2.setMetric(DescriptiveStatistics::getMean);
                return this.getMCTS(input, fcFactory2, Integer.MAX_VALUE, seed);
            }
            case "dng": {
                return this.getMCTS(input, new DNGMCTSFactory(), Integer.MAX_VALUE, seed);
            }
            case "tag": {
                return this.getMCTS(input, new TAGMCTSFactory(), Integer.MAX_VALUE, seed);
            }
            case "brue": {
                return this.getMCTS(input, new BRUEFactory(), Integer.MAX_VALUE, seed);
            }
            case "dfs": {
                IteratingGraphSearchOptimizerFactory dfsFactory = new IteratingGraphSearchOptimizerFactory();
                dfsFactory.setBaseAlgorithmFactory(new DepthFirstSearchFactory());
                return dfsFactory.getAlgorithm(input);
            }
        }
        throw new IllegalArgumentException("Unsupported algorithm " + algorithm);
    }
}

