/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.gui.plugins.mcts.bradleyterry;

import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginController;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ResetEvent;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.NodeClickedEvent;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.ObservationsUpdatedEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.RolloutEvent;
import ai.libs.jaicore.search.gui.plugins.mcts.bradleyterry.BradleyTerryPluginModel;
import ai.libs.jaicore.search.gui.plugins.mcts.bradleyterry.BradleyTerryPluginView;
import ai.libs.jaicore.search.gui.plugins.mcts.bradleyterry.BradleyTerryUpdate;
import ai.libs.jaicore.search.gui.plugins.rollouthistograms.RolloutInfo;
import java.util.ArrayList;
import java.util.List;
import org.api4.java.algorithm.events.serializable.IPropertyProcessedAlgorithmEvent;

public class BradleyTerryPluginController
extends ASimpleMVCPluginController<BradleyTerryPluginModel, BradleyTerryPluginView> {
    public BradleyTerryPluginController(BradleyTerryPluginModel model, BradleyTerryPluginView view) {
        super((ASimpleMVCPluginModel)model, (ASimpleMVCPluginView)view);
    }

    public void handleGUIEvent(GUIEvent guiEvent) {
        if (guiEvent instanceof ResetEvent || guiEvent instanceof GoToTimeStepEvent) {
            ((BradleyTerryPluginModel)this.getModel()).clear();
        } else if (guiEvent instanceof NodeClickedEvent) {
            ((BradleyTerryPluginModel)this.getModel()).setCurrentlySelectedNode(((NodeClickedEvent)guiEvent).getSearchGraphNode());
            ((BradleyTerryPluginView)this.getView()).update();
        }
    }

    public void handleAlgorithmEventInternally(IPropertyProcessedAlgorithmEvent algorithmEvent) {
        if (algorithmEvent.correspondsToEventOfClass(RolloutEvent.class)) {
            RolloutInfo rolloutInfo = (RolloutInfo)algorithmEvent.getProperty("rollout_info");
            String lastNode = null;
            for (String n : rolloutInfo.getPath()) {
                if (lastNode != null) {
                    List successors = ((BradleyTerryPluginModel)this.getModel()).getListsOfKnownSuccessors().computeIfAbsent(lastNode, k -> new ArrayList());
                    if (!successors.contains(n)) {
                        successors.add(n);
                    }
                    ((BradleyTerryPluginModel)this.getModel()).getParents().put(n, lastNode);
                }
                lastNode = n;
            }
        } else if (algorithmEvent.correspondsToEventOfClass(ObservationsUpdatedEvent.class)) {
            BradleyTerryUpdate updateInfo = (BradleyTerryUpdate)algorithmEvent.getProperty("bt_update");
            ((BradleyTerryPluginModel)this.getModel()).setNodeStats(updateInfo);
        }
    }
}

