/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.gui.plugins.mcts.bradleyterry;

import ai.libs.jaicore.graphvisualizer.events.gui.DefaultGUIEventBus;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.NodeClickedEvent;
import ai.libs.jaicore.search.gui.plugins.mcts.bradleyterry.BradleyTerryPluginController;
import ai.libs.jaicore.search.gui.plugins.mcts.bradleyterry.BradleyTerryPluginModel;
import ai.libs.jaicore.search.gui.plugins.mcts.bradleyterry.BradleyTerryUpdate;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.FlowPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class BradleyTerryPluginView
extends ASimpleMVCPluginView<BradleyTerryPluginModel, BradleyTerryPluginController, FlowPane> {
    private final Button left = new Button("left");
    private final Button right = new Button("right");
    private final Button parent = new Button("parent");
    private WebEngine engine;
    private static final String HTML_TD_OPEN = "<td>";
    private static final String HTML_TD_CLOSE = "</td>";
    private static final String HTML_TR_OPEN = "<tr>";
    private static final String HTML_TR_CLOSE = "</tr>";

    public BradleyTerryPluginView(BradleyTerryPluginModel model) {
        super((IGUIPluginModel)model, (Node)new FlowPane());
        Platform.runLater(() -> {
            WebView view = new WebView();
            FlowPane node = (FlowPane)this.getNode();
            node.getChildren().add((Object)this.left);
            node.getChildren().add((Object)this.right);
            node.getChildren().add((Object)this.parent);
            this.left.setOnMouseClicked(e -> {
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, this.getLeftChild(model.getCurrentlySelectedNode())));
                this.parent.setDisable(false);
            });
            this.right.setOnMouseClicked(e -> {
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, this.getRightChild(model.getCurrentlySelectedNode())));
                this.parent.setDisable(false);
            });
            this.parent.setOnMouseClicked(e -> {
                String parentOfCurrent = ((BradleyTerryPluginModel)this.getModel()).getParentOfCurrentNode();
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, parentOfCurrent));
                if (!((BradleyTerryPluginModel)this.getModel()).getParents().containsKey(parentOfCurrent)) {
                    this.parent.setDisable(true);
                }
            });
            node.getChildren().add((Object)view);
            this.engine = view.getEngine();
            this.engine.loadContent("Nothing there yet.");
        });
    }

    private String getLeftChild(String node) {
        return ((BradleyTerryPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).get(0);
    }

    private String getRightChild(String node) {
        return ((BradleyTerryPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).size() > 1 ? ((BradleyTerryPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).get(1) : null;
    }

    public void update() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>Analysis of node ");
        String currentNode = ((BradleyTerryPluginModel)this.getModel()).getCurrentlySelectedNode();
        sb.append(currentNode);
        sb.append(" (depth ");
        Map<String, String> parents = ((BradleyTerryPluginModel)this.getModel()).getParents();
        int depth = 0;
        while (parents.containsKey(currentNode)) {
            currentNode = parents.get(currentNode);
            ++depth;
        }
        sb.append(depth);
        sb.append(")</h2>");
        BradleyTerryUpdate update = ((BradleyTerryPluginModel)this.getModel()).getUpdateOfSelectedNode();
        if (update != null) {
            sb.append("<p>Number of visits: ");
            sb.append(update.getVisits());
            sb.append("</p>");
            sb.append("<h2>Stats of children</h2><table><tr>");
            BradleyTerryUpdate modelOfLeftChild = ((BradleyTerryPluginModel)this.getModel()).getBtUpdates().get(this.getLeftChild(update.getNode()));
            BradleyTerryUpdate modelOfRightChild = ((BradleyTerryPluginModel)this.getModel()).getBtUpdates().get(this.getRightChild(update.getNode()));
            sb.append(HTML_TD_OPEN);
            sb.append(modelOfLeftChild != null ? modelOfLeftChild.getVisits() : 0);
            sb.append(HTML_TD_CLOSE);
            sb.append(HTML_TD_OPEN);
            sb.append(modelOfRightChild != null ? modelOfRightChild.getVisits() : 0);
            sb.append(HTML_TD_CLOSE);
            sb.append(HTML_TR_CLOSE);
            sb.append(HTML_TR_OPEN);
            sb.append(HTML_TD_OPEN);
            sb.append(update.getWinsLeft());
            sb.append(HTML_TD_CLOSE);
            sb.append(HTML_TD_OPEN);
            sb.append(update.getWinsRight());
            sb.append(HTML_TD_CLOSE);
            sb.append(HTML_TR_CLOSE);
            sb.append(HTML_TR_OPEN);
            sb.append(HTML_TD_OPEN);
            sb.append(update.getpLeftScaled());
            sb.append(" (");
            sb.append(update.getpLeft());
            sb.append(")</td>");
            sb.append(HTML_TD_OPEN);
            sb.append(update.getpRightScaled());
            sb.append(" (");
            sb.append(update.getpRight());
            sb.append(")</td>");
            sb.append(HTML_TR_CLOSE);
            sb.append(HTML_TR_OPEN);
            DescriptiveStatistics leftStats = new DescriptiveStatistics();
            update.getScoresLeft().forEach(arg_0 -> ((DescriptiveStatistics)leftStats).addValue(arg_0));
            DescriptiveStatistics rightStats = new DescriptiveStatistics();
            update.getScoresRight().forEach(arg_0 -> ((DescriptiveStatistics)rightStats).addValue(arg_0));
            sb.append(HTML_TD_OPEN);
            sb.append(leftStats.toString().replace("\n", "<br />"));
            sb.append(HTML_TD_CLOSE);
            sb.append(HTML_TD_OPEN);
            sb.append(rightStats.toString().replace("\n", "<br />"));
            sb.append(HTML_TD_CLOSE);
            sb.append("</tr><tr>");
            sb.append("<td style=\"vertical-align: top;\"><ul>");
            update.getScoresLeft().forEach(d -> sb.append("<li>" + d + "</li>"));
            sb.append("</ul></td>");
            sb.append("<td style=\"vertical-align: top;\"><ul>");
            update.getScoresRight().forEach(d -> sb.append("<li>" + d + "</li>"));
            sb.append("</ul></td>");
            sb.append("</tr></table>");
        }
        Platform.runLater(() -> this.engine.loadContent(sb.toString()));
    }

    public void clear() {
    }
}

