/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.gui.plugins.mcts.dng;

import ai.libs.jaicore.graphvisualizer.events.recorder.property.AlgorithmEventPropertyComputer;
import ai.libs.jaicore.graphvisualizer.events.recorder.property.PropertyComputationFailedException;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoAlgorithmEventPropertyComputer;
import ai.libs.jaicore.search.algorithms.mdp.mcts.thompson.DNGBeliefUpdateEvent;
import ai.libs.jaicore.search.algorithms.mdp.mcts.thompson.DNGQSampleEvent;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGBeliefUpdate;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGQSample;
import java.util.Arrays;
import java.util.List;
import org.api4.java.algorithm.events.IAlgorithmEvent;

public class DNGEventPropertyComputer
implements AlgorithmEventPropertyComputer {
    public static final String UPDATE_PROPERTY_NAME = "dng_update";
    private NodeInfoAlgorithmEventPropertyComputer nodeInfoAlgorithmEventPropertyComputer;

    public DNGEventPropertyComputer(NodeInfoAlgorithmEventPropertyComputer nodeInfoAlgorithmEventPropertyComputer) {
        this.nodeInfoAlgorithmEventPropertyComputer = nodeInfoAlgorithmEventPropertyComputer;
    }

    public Object computeAlgorithmEventProperty(IAlgorithmEvent algorithmEvent) throws PropertyComputationFailedException {
        if (algorithmEvent instanceof DNGQSampleEvent) {
            DNGQSampleEvent dngEvent = (DNGQSampleEvent)algorithmEvent;
            String idOfNode = this.nodeInfoAlgorithmEventPropertyComputer.getIdOfNodeIfExistent(dngEvent.getNode());
            return new DNGQSample(idOfNode, dngEvent.getAction().toString(), dngEvent.getScore());
        }
        if (algorithmEvent instanceof DNGBeliefUpdateEvent) {
            DNGBeliefUpdateEvent dngEvent = (DNGBeliefUpdateEvent)algorithmEvent;
            String idOfNode = this.nodeInfoAlgorithmEventPropertyComputer.getIdOfNodeIfExistent(dngEvent.getNode());
            return new DNGBeliefUpdate(idOfNode, dngEvent.getMu(), dngEvent.getAlpha(), dngEvent.getBeta(), dngEvent.getLambda());
        }
        return null;
    }

    public String getPropertyName() {
        return UPDATE_PROPERTY_NAME;
    }

    public List<AlgorithmEventPropertyComputer> getRequiredPropertyComputers() {
        return Arrays.asList(this.nodeInfoAlgorithmEventPropertyComputer);
    }

    public void overwriteRequiredPropertyComputer(AlgorithmEventPropertyComputer computer) {
        this.nodeInfoAlgorithmEventPropertyComputer = (NodeInfoAlgorithmEventPropertyComputer)computer;
    }
}

