/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.gui.plugins.mcts.dng;

import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginController;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ResetEvent;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.NodeClickedEvent;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import ai.libs.jaicore.search.algorithms.mdp.mcts.thompson.DNGBeliefUpdateEvent;
import ai.libs.jaicore.search.algorithms.mdp.mcts.thompson.DNGQSampleEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.RolloutEvent;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGBeliefUpdate;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGMCTSPluginModel;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGMCTSPluginView;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGQSample;
import ai.libs.jaicore.search.gui.plugins.rollouthistograms.RolloutInfo;
import java.util.ArrayList;
import java.util.List;
import org.api4.java.algorithm.events.serializable.IPropertyProcessedAlgorithmEvent;

public class DNGMCTSPluginController
extends ASimpleMVCPluginController<DNGMCTSPluginModel, DNGMCTSPluginView> {
    public DNGMCTSPluginController(DNGMCTSPluginModel model, DNGMCTSPluginView view) {
        super((ASimpleMVCPluginModel)model, (ASimpleMVCPluginView)view);
    }

    public void handleGUIEvent(GUIEvent guiEvent) {
        if (guiEvent instanceof ResetEvent || guiEvent instanceof GoToTimeStepEvent) {
            ((DNGMCTSPluginModel)this.getModel()).clear();
        } else if (guiEvent instanceof NodeClickedEvent) {
            ((DNGMCTSPluginModel)this.getModel()).setCurrentlySelectedNode(((NodeClickedEvent)guiEvent).getSearchGraphNode());
            ((DNGMCTSPluginView)this.getView()).update();
        }
    }

    public void handleAlgorithmEventInternally(IPropertyProcessedAlgorithmEvent algorithmEvent) {
        if (algorithmEvent.correspondsToEventOfClass(RolloutEvent.class)) {
            RolloutInfo rolloutInfo = (RolloutInfo)algorithmEvent.getProperty("rollout_info");
            String lastNode = null;
            for (String n : rolloutInfo.getPath()) {
                if (lastNode != null) {
                    List successors = ((DNGMCTSPluginModel)this.getModel()).getListsOfKnownSuccessors().computeIfAbsent(lastNode, k -> new ArrayList());
                    if (!successors.contains(n)) {
                        successors.add(n);
                    }
                    ((DNGMCTSPluginModel)this.getModel()).getParents().put(n, lastNode);
                }
                ((DNGMCTSPluginModel)this.getModel()).addObservation(n, (Double)rolloutInfo.getScore());
                lastNode = n;
            }
        } else if (algorithmEvent.correspondsToEventOfClass(DNGQSampleEvent.class)) {
            DNGQSample updateInfo = (DNGQSample)algorithmEvent.getProperty("dng_update");
            ((DNGMCTSPluginModel)this.getModel()).setNodeStats(updateInfo);
        } else if (algorithmEvent.correspondsToEventOfClass(DNGBeliefUpdateEvent.class)) {
            DNGBeliefUpdate updateInfo = (DNGBeliefUpdate)algorithmEvent.getProperty("dng_update");
            ((DNGMCTSPluginModel)this.getModel()).setNodeStats(updateInfo);
        }
    }
}

