/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.gui.plugins.mcts.dng;

import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginModel;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGBeliefUpdate;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGMCTSPluginController;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGMCTSPluginView;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGQSample;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class DNGMCTSPluginModel
extends ASimpleMVCPluginModel<DNGMCTSPluginView, DNGMCTSPluginController> {
    private String currentlySelectedNode = "0";
    private final Map<String, String> parents = new HashMap<String, String>();
    private final Map<String, List<String>> listsOfKnownSuccessors = new HashMap<String, List<String>>();
    private final Map<String, List<Double>> listOfObersvationsPerNode = new HashMap<String, List<Double>>();
    private final Map<String, Map<String, List<Double>>> observedQValues = new HashMap<String, Map<String, List<Double>>>();
    private final Map<String, List<DNGBeliefUpdate>> observedUpdates = new HashMap<String, List<DNGBeliefUpdate>>();

    public void clear() {
        ((DNGMCTSPluginView)this.getView()).clear();
    }

    public void setCurrentlySelectedNode(String currentlySelectedNode) {
        this.currentlySelectedNode = currentlySelectedNode;
        ((DNGMCTSPluginView)this.getView()).clear();
        ((DNGMCTSPluginView)this.getView()).update();
    }

    public String getCurrentlySelectedNode() {
        return this.currentlySelectedNode;
    }

    public void addObservation(String node, double score) {
        this.listOfObersvationsPerNode.computeIfAbsent(node, n -> new ArrayList()).add(score);
    }

    public void setNodeStats(DNGQSample update) {
        if (update == null) {
            throw new IllegalArgumentException("Cannot process NULL update");
        }
        String node = update.getNode();
        if (!this.listsOfKnownSuccessors.containsKey(node)) {
            throw new IllegalArgumentException("Cannot receive update for an unknown node. Make sure that Rollout events are processed!");
        }
        this.observedQValues.computeIfAbsent(node, n -> new HashMap()).computeIfAbsent(update.getSuccessor(), n2 -> new ArrayList()).add(update.getScore());
        if (node.equals(this.getCurrentlySelectedNode())) {
            ((DNGMCTSPluginView)this.getView()).update();
        }
    }

    public void setNodeStats(DNGBeliefUpdate update) {
        if (update == null) {
            throw new IllegalArgumentException("Cannot process NULL update");
        }
        String node = update.getNode();
        this.observedUpdates.computeIfAbsent(node, n -> new ArrayList()).add(update);
        if (node.equals(this.getCurrentlySelectedNode())) {
            ((DNGMCTSPluginView)this.getView()).update();
        }
    }

    public Map<String, List<Double>> getQValuesOfNode(String node) {
        return this.observedQValues.get(node);
    }

    public Map<String, List<Double>> getQValuesOfSelectedNode() {
        return this.observedQValues.get(this.getCurrentlySelectedNode());
    }

    public Map<String, List<String>> getListsOfKnownSuccessors() {
        return this.listsOfKnownSuccessors;
    }

    public List<String> getListOfKnownSuccessorsOfCurrentlySelectedNode() {
        return this.listsOfKnownSuccessors.get(this.getCurrentlySelectedNode());
    }

    public Map<String, String> getParents() {
        return this.parents;
    }

    public String getParentOfCurrentNode() {
        return this.parents.get(this.getCurrentlySelectedNode());
    }

    public Map<String, List<DNGBeliefUpdate>> getObservedMuValues() {
        return this.observedUpdates;
    }

    public List<DNGBeliefUpdate> getObservedMuValuesOfCurrentlySelectedNode() {
        return this.observedUpdates.get(this.getCurrentlySelectedNode());
    }

    public Map<String, List<Double>> getListOfObersvationsPerNode() {
        return this.listOfObersvationsPerNode;
    }

    public DescriptiveStatistics getObservationStatisticsOfNode(String node) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (double val : this.listOfObersvationsPerNode.get(node)) {
            stats.addValue(val);
        }
        return stats;
    }
}

