/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.gui.plugins.mcts.dng;

import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.graphvisualizer.events.gui.DefaultGUIEventBus;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.NodeClickedEvent;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGBeliefUpdate;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGMCTSPluginController;
import ai.libs.jaicore.search.gui.plugins.mcts.dng.DNGMCTSPluginModel;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.FlowPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class DNGMCTSPluginView
extends ASimpleMVCPluginView<DNGMCTSPluginModel, DNGMCTSPluginController, FlowPane> {
    private final Button left = new Button("left");
    private final Button right = new Button("right");
    private final Button parent = new Button("parent");
    private WebEngine engine;
    private static final String HTML_BR = "<br />";
    private static final String HTML_H4_OPEN = "<h4>";
    private static final String HTML_H4_CLOSE = "</h4>";

    public DNGMCTSPluginView(DNGMCTSPluginModel model) {
        super((IGUIPluginModel)model, (Node)new FlowPane());
        Platform.runLater(() -> {
            WebView view = new WebView();
            FlowPane node = (FlowPane)this.getNode();
            node.getChildren().add((Object)this.left);
            node.getChildren().add((Object)this.right);
            node.getChildren().add((Object)this.parent);
            this.left.setOnMouseClicked(e -> {
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, this.getLeftChild(model.getCurrentlySelectedNode())));
                this.parent.setDisable(false);
            });
            this.right.setOnMouseClicked(e -> {
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, this.getRightChild(model.getCurrentlySelectedNode())));
                this.parent.setDisable(false);
            });
            this.parent.setOnMouseClicked(e -> {
                String parentOfCurrent = ((DNGMCTSPluginModel)this.getModel()).getParentOfCurrentNode();
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, parentOfCurrent));
                if (!((DNGMCTSPluginModel)this.getModel()).getParents().containsKey(parentOfCurrent)) {
                    this.parent.setDisable(true);
                }
            });
            node.getChildren().add((Object)view);
            this.engine = view.getEngine();
            this.engine.loadContent("Nothing there yet.");
        });
    }

    private String getLeftChild(String node) {
        return ((DNGMCTSPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).get(0);
    }

    private String getRightChild(String node) {
        return ((DNGMCTSPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).size() > 1 ? ((DNGMCTSPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).get(1) : null;
    }

    public void update() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>Analysis of node ");
        String currentNode = ((DNGMCTSPluginModel)this.getModel()).getCurrentlySelectedNode();
        sb.append(currentNode);
        sb.append(" (depth ");
        Map<String, String> parents = ((DNGMCTSPluginModel)this.getModel()).getParents();
        int depth = 0;
        while (parents.containsKey(currentNode)) {
            currentNode = parents.get(currentNode);
            ++depth;
        }
        sb.append(depth);
        sb.append(")</h2>");
        sb.append("<h3>Mu-Estimates of Children</h3>");
        String currentlySelectedNode = ((DNGMCTSPluginModel)this.getModel()).getCurrentlySelectedNode();
        String leftChild = this.getLeftChild(currentlySelectedNode);
        String rightChild = this.getRightChild(currentlySelectedNode);
        List<DNGBeliefUpdate> muValuesOfLeft = ((DNGMCTSPluginModel)this.getModel()).getObservedMuValues().get(leftChild);
        sb.append(HTML_H4_OPEN + leftChild + " (" + (muValuesOfLeft != null ? Integer.valueOf(muValuesOfLeft.size()) : "-1") + ")");
        sb.append(HTML_H4_CLOSE);
        if (muValuesOfLeft != null) {
            DNGBeliefUpdate latestUpdate = muValuesOfLeft.get(muValuesOfLeft.size() - 1);
            DescriptiveStatistics statsOfLeft = ((DNGMCTSPluginModel)this.getModel()).getObservationStatisticsOfNode(leftChild);
            sb.append("Mu: " + latestUpdate.getMu() + HTML_BR);
            sb.append("Mu - sampleMean: " + (latestUpdate.getMu() - statsOfLeft.getMean()) + HTML_BR);
            sb.append("Alpha: " + latestUpdate.getAlpha() + HTML_BR);
            sb.append("Beta: " + latestUpdate.getBeta() + HTML_BR);
            sb.append("Lambda: " + latestUpdate.getLambda());
        }
        if (rightChild != null) {
            List<DNGBeliefUpdate> muValuesOfRight = ((DNGMCTSPluginModel)this.getModel()).getObservedMuValues().get(rightChild);
            DescriptiveStatistics statsOfRight = ((DNGMCTSPluginModel)this.getModel()).getObservationStatisticsOfNode(rightChild);
            sb.append(HTML_H4_OPEN + rightChild + " (" + (muValuesOfRight != null ? Integer.valueOf(muValuesOfRight.size()) : "-1") + ")");
            sb.append(HTML_H4_CLOSE);
            if (muValuesOfRight != null) {
                DNGBeliefUpdate latestUpdate = muValuesOfRight.get(muValuesOfRight.size() - 1);
                sb.append("Mu: " + latestUpdate.getMu() + HTML_BR);
                sb.append("Mu - sampleMean: " + (latestUpdate.getMu() - statsOfRight.getMean()) + HTML_BR);
                sb.append("Alpha: " + latestUpdate.getAlpha() + HTML_BR);
                sb.append("Beta: " + latestUpdate.getBeta() + HTML_BR);
                sb.append("Lambda: " + latestUpdate.getLambda());
            }
        }
        sb.append("<h3>Q-Values of Children</h3>");
        Map<String, List<Double>> qValues = ((DNGMCTSPluginModel)this.getModel()).getQValuesOfSelectedNode();
        if (qValues != null) {
            List<Double> scoresOfLeft = qValues.get(leftChild);
            sb.append(HTML_H4_OPEN);
            sb.append(leftChild + " (" + scoresOfLeft.size() + ")");
            sb.append(HTML_H4_CLOSE);
            sb.append(scoresOfLeft.subList(Math.max(0, scoresOfLeft.size() - 5), scoresOfLeft.size()).stream().map(v -> MathExt.round((double)v, (int)4)).collect(Collectors.toList()));
            List<Double> scoresOfRight = qValues.get(rightChild);
            if (scoresOfRight != null) {
                sb.append(HTML_H4_OPEN);
                sb.append(rightChild + " (" + scoresOfRight.size() + ")");
                sb.append(HTML_H4_CLOSE);
                sb.append(scoresOfRight.subList(Math.max(0, scoresOfRight.size() - 5), scoresOfRight.size()).stream().map(v -> MathExt.round((double)v, (int)4)).collect(Collectors.toList()));
            }
        }
        Platform.runLater(() -> this.engine.loadContent(sb.toString()));
    }

    public void clear() {
    }
}

