/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.gui.plugins.rolloutboxplots;

import ai.libs.jaicore.graphvisualizer.events.gui.DefaultGUIEventBus;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.NodeClickedEvent;
import ai.libs.jaicore.search.gui.plugins.rolloutboxplots.SearchRolloutBoxplotPluginController;
import ai.libs.jaicore.search.gui.plugins.rolloutboxplots.SearchRolloutBoxplotPluginModel;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class SearchRolloutBoxplotPluginView
extends ASimpleMVCPluginView<SearchRolloutBoxplotPluginModel, SearchRolloutBoxplotPluginController, StackPane> {
    private final Button left = new Button("left");
    private final Button right = new Button("right");
    private final Button parent = new Button("parent");
    private WebEngine engine;

    public SearchRolloutBoxplotPluginView(SearchRolloutBoxplotPluginModel model) {
        super((IGUIPluginModel)model, (Node)new StackPane());
        Platform.runLater(() -> {
            WebView view = new WebView();
            StackPane node = (StackPane)this.getNode();
            node.getChildren().add((Object)view);
            this.engine = view.getEngine();
            this.engine.loadContent("Nothing there yet.");
            node.getChildren().add((Object)this.left);
            node.getChildren().add((Object)this.right);
            node.getChildren().add((Object)this.parent);
            this.left.setOnMouseClicked(e -> {
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, this.getLeftChild(model.getCurrentlySelectedNode())));
                this.parent.setDisable(false);
            });
            this.right.setOnMouseClicked(e -> {
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, this.getRightChild(model.getCurrentlySelectedNode())));
                this.parent.setDisable(false);
            });
            this.parent.setOnMouseClicked(e -> {
                String parentOfCurrent = ((SearchRolloutBoxplotPluginModel)this.getModel()).getParentOfCurrentNode();
                DefaultGUIEventBus.getInstance().postEvent((GUIEvent)new NodeClickedEvent(null, parentOfCurrent));
                if (!((SearchRolloutBoxplotPluginModel)this.getModel()).getParents().containsKey(parentOfCurrent)) {
                    this.parent.setDisable(true);
                }
            });
        });
    }

    private String getLeftChild(String node) {
        if (!((SearchRolloutBoxplotPluginModel)this.getModel()).getListsOfKnownSuccessors().containsKey(node)) {
            throw new IllegalArgumentException(node + " has no children in the known model!");
        }
        return ((SearchRolloutBoxplotPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).get(0);
    }

    private String getRightChild(String node) {
        return ((SearchRolloutBoxplotPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).size() > 1 ? ((SearchRolloutBoxplotPluginModel)this.getModel()).getListsOfKnownSuccessors().get(node).get(1) : null;
    }

    public synchronized void update() {
        StringBuilder sb = new StringBuilder();
        DescriptiveStatistics stats = ((SearchRolloutBoxplotPluginModel)this.getModel()).getObservedPerformancesUnderSelectedNode();
        if (stats != null) {
            sb.append(stats.toString().replace("\n", "<br />"));
            List<String> successors = ((SearchRolloutBoxplotPluginModel)this.getModel()).getListOfKnownSuccessorsOfCurrentlySelectedNode();
            if (successors != null) {
                sb.append("<table><tr>");
                for (String successor : successors) {
                    DescriptiveStatistics statsOfSuccessor = ((SearchRolloutBoxplotPluginModel)this.getModel()).getObservedPerformances().get(successor);
                    sb.append("<td>");
                    sb.append(statsOfSuccessor.toString().replace("\n", "<br />"));
                    sb.append("</td>");
                }
                sb.append("</tr></table>");
            }
            Platform.runLater(() -> this.engine.loadContent(sb.toString()));
        }
    }

    public synchronized void clear() {
    }
}

