/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.gui.plugins.rollouthistograms;

import ai.libs.jaicore.graphvisualizer.events.recorder.property.AlgorithmEventPropertyComputer;
import ai.libs.jaicore.graphvisualizer.events.recorder.property.PropertyComputationFailedException;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoAlgorithmEventPropertyComputer;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.RolloutEvent;
import ai.libs.jaicore.search.gui.plugins.rollouthistograms.RolloutInfo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.api4.java.algorithm.events.IAlgorithmEvent;

public class RolloutInfoAlgorithmEventPropertyComputer
implements AlgorithmEventPropertyComputer {
    public static final String ROLLOUT_SCORE_PROPERTY_NAME = "rollout_info";
    private NodeInfoAlgorithmEventPropertyComputer nodeInfoAlgorithmEventPropertyComputer = new NodeInfoAlgorithmEventPropertyComputer();

    public Object computeAlgorithmEventProperty(IAlgorithmEvent algorithmEvent) throws PropertyComputationFailedException {
        if (algorithmEvent instanceof RolloutEvent) {
            RolloutEvent rolloutEvent = (RolloutEvent)algorithmEvent;
            List rolloutPath = rolloutEvent.getPath();
            return new RolloutInfo(this.convertNodeToNodeIds(rolloutPath), rolloutEvent.getScore());
        }
        return null;
    }

    private List<String> convertNodeToNodeIds(List<?> pathNodes) throws PropertyComputationFailedException {
        List<String> path = pathNodes.stream().map(n -> n).map(n -> this.nodeInfoAlgorithmEventPropertyComputer.getIdOfNodeIfExistent(n)).collect(Collectors.toList());
        if (path.contains(null)) {
            throw new PropertyComputationFailedException("Cannot compute rollout score due to null nodes in path: " + path);
        }
        return path;
    }

    public String getPropertyName() {
        return ROLLOUT_SCORE_PROPERTY_NAME;
    }

    public List<AlgorithmEventPropertyComputer> getRequiredPropertyComputers() {
        return Arrays.asList(this.nodeInfoAlgorithmEventPropertyComputer);
    }

    public void overwriteRequiredPropertyComputer(AlgorithmEventPropertyComputer computer) {
        this.nodeInfoAlgorithmEventPropertyComputer = (NodeInfoAlgorithmEventPropertyComputer)computer;
    }
}

