/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.landscapeanalysis;

import ai.libs.jaicore.search.landscapeanalysis.LandscapeAnalysisCompletionTechnique;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericLandscapeAnalyzer<N, A> {
    private static Logger logger = LoggerFactory.getLogger((String)"testers");
    private final IPathSearchWithPathEvaluationsInput<N, A, Double> problem;
    private final N root;
    private final ISuccessorGenerator<N, A> successorGenerator;
    private final IPathGoalTester<N, A> goalTester;
    private double min = Double.MAX_VALUE;

    public GenericLandscapeAnalyzer(IPathSearchWithPathEvaluationsInput<N, A, Double> problem) {
        this.problem = problem;
        this.root = problem.getGraphGenerator().getRootGenerator().getRoots().iterator().next();
        this.successorGenerator = problem.getGraphGenerator().getSuccessorGenerator();
        this.goalTester = problem.getGoalTester();
    }

    public double[] getValues(Number probeSize) throws InterruptedException, PathEvaluationException {
        return this.getValues(probeSize, LandscapeAnalysisCompletionTechnique.RANDOM);
    }

    public double[] getValues(Number probeSize, LandscapeAnalysisCompletionTechnique technique) throws InterruptedException, PathEvaluationException {
        return this.getValues(new SearchGraphPath(this.root), probeSize, technique);
    }

    public double[] getValues(List<Integer> decisions, int probeSize, LandscapeAnalysisCompletionTechnique technique) throws InterruptedException, PathEvaluationException {
        ArrayList<N> nodes = new ArrayList<N>(decisions.size() + 1);
        ArrayList<Object> arcs = new ArrayList<Object>(decisions.size());
        Object current = this.root;
        nodes.add(current);
        for (int child : decisions) {
            INewNodeDescription ned = (INewNodeDescription)this.successorGenerator.generateSuccessors(current).get(child);
            current = ned.getTo();
            nodes.add(current);
            arcs.add(ned.getArcLabel());
        }
        SearchGraphPath path = new SearchGraphPath(nodes, arcs);
        return this.getValues(path, (Number)probeSize, technique);
    }

    public double[] getValues(ILabeledPath<N, A> path, Number probeSize, LandscapeAnalysisCompletionTechnique technique) throws InterruptedException, PathEvaluationException {
        List<Double> values = this.probeUnderPath(path, probeSize, technique);
        int n = values.size();
        double[] valuesAsArray = new double[n];
        for (int i = 0; i < n; ++i) {
            valuesAsArray[i] = values.get(i);
        }
        return valuesAsArray;
    }

    private List<Double> probeUnderPath(ILabeledPath<N, A> path, Number limit, LandscapeAnalysisCompletionTechnique technique) throws InterruptedException, PathEvaluationException {
        Object node = path.getHead();
        int cLimit = limit.intValue();
        ArrayList<Double> scoresUnderChildren = new ArrayList<Double>(cLimit);
        if (this.goalTester.isGoal(path)) {
            double score = (Double)this.problem.getPathEvaluator().evaluate(path);
            if (score < this.min) {
                this.min = score;
            }
            scoresUnderChildren.add(score);
            return scoresUnderChildren;
        }
        List successors = this.successorGenerator.generateSuccessors(node);
        int n = successors.size();
        if (n > cLimit) {
            switch (technique) {
                case FIRST: {
                    break;
                }
                case LAST: {
                    Collections.reverse(successors);
                    break;
                }
                case RANDOM: {
                    Collections.shuffle(successors);
                }
            }
        }
        int limitPerChild = (int)Math.floor((double)cLimit * 1.0 / (double)n);
        int numberOfChildrenWithExtra = cLimit % n;
        for (int child = 0; child < n; ++child) {
            int limitForThisChild = limitPerChild + (child < numberOfChildrenWithExtra ? 1 : 0);
            if (limitForThisChild <= 0) {
                return scoresUnderChildren;
            }
            SearchGraphPath<Object, Object> newPath = new SearchGraphPath<Object, Object>(path, ((INewNodeDescription)successors.get(child)).getTo(), ((INewNodeDescription)successors.get(child)).getArcLabel());
            scoresUnderChildren.addAll(this.probeUnderPath(newPath, limitForThisChild, technique));
        }
        return scoresUnderChildren;
    }

    public List<List<double[]>> getIterativeProbeValuesAlongRandomPath(Number probSizePerLevelAndChild) throws PathEvaluationException, InterruptedException {
        SearchGraphPath<Object, Object> currentPath = new SearchGraphPath(this.root);
        while (!this.goalTester.isGoal(currentPath)) {
            List nedList = this.problem.getGraphGenerator().getSuccessorGenerator().generateSuccessors(currentPath.getHead());
            Collections.shuffle(nedList);
            currentPath = new SearchGraphPath<Object, Object>(currentPath, ((INewNodeDescription)nedList.get(0)).getTo(), ((INewNodeDescription)nedList.get(0)).getArcLabel());
        }
        logger.info("Drew path {}: {}", (Object)currentPath.getArcs(), currentPath.getHead());
        return this.getIterativeProbeValues(currentPath, probSizePerLevelAndChild);
    }

    public List<List<double[]>> getIterativeProbeValues(ILabeledPath<N, A> path, Number probSizePerLevelAndChild) throws PathEvaluationException, InterruptedException {
        ArrayList<List<double[]>> iterativeProbes = new ArrayList<List<double[]>>();
        for (int depth = 0; depth < path.getNumberOfNodes() - 1; ++depth) {
            logger.info("Probing on level {}", (Object)depth);
            ILabeledPath subPath = path;
            while (subPath.getNumberOfNodes() > depth + 1) {
                subPath = subPath.getPathToParentOfHead();
            }
            List nedList = this.problem.getGraphGenerator().getSuccessorGenerator().generateSuccessors(subPath.getHead());
            ArrayList<double[]> probesOnLevel = new ArrayList<double[]>(nedList.size());
            for (INewNodeDescription ned : nedList) {
                SearchGraphPath<Object, Object> extendedPath = new SearchGraphPath<Object, Object>(subPath, ned.getTo(), ned.getArcLabel());
                double[] landscape = this.getValues(extendedPath, probSizePerLevelAndChild, LandscapeAnalysisCompletionTechnique.RANDOM);
                probesOnLevel.add(landscape);
            }
            iterativeProbes.add(probesOnLevel);
        }
        return iterativeProbes;
    }
}

