/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.model.other;

import ai.libs.jaicore.graph.ReadOnlyPathAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.api4.java.datastructure.graph.ILabeledPath;

public class SearchGraphPath<N, A>
implements ILabeledPath<N, A> {
    private final List<N> nodes;
    private final List<A> edges;
    private final Map<String, Object> annotations;

    public SearchGraphPath(ILabeledPath<N, A> path) {
        this(new ArrayList(path.getNodes()), new ArrayList(path.getArcs()), (Map<String, Object>)(path instanceof SearchGraphPath ? new HashMap<String, Object>(((SearchGraphPath)path).annotations) : new HashMap()));
    }

    public SearchGraphPath(ILabeledPath<N, A> pathA, ILabeledPath<N, A> pathB, A link) {
        this.nodes = new ArrayList<N>();
        this.nodes.addAll(pathA.getNodes());
        this.nodes.addAll(pathB.getNodes());
        this.edges = new ArrayList<A>();
        this.edges.addAll(pathA.getArcs());
        this.edges.add(link);
        this.edges.addAll(pathB.getArcs());
        this.annotations = new HashMap<String, Object>();
    }

    public SearchGraphPath(ILabeledPath<N, A> pathA, N attachedNode, A link) {
        this.nodes = new ArrayList<N>();
        this.nodes.addAll(pathA.getNodes());
        this.nodes.add(attachedNode);
        this.edges = new ArrayList<A>();
        this.edges.addAll(pathA.getArcs());
        this.edges.add(link);
        this.annotations = new HashMap<String, Object>();
    }

    public SearchGraphPath(N node) {
        this(new ArrayList<N>(Collections.singletonList(node)), new ArrayList(), new HashMap<String, Object>());
    }

    public SearchGraphPath(List<N> nodes, List<A> edges) {
        this(nodes, edges, new HashMap<String, Object>());
    }

    public SearchGraphPath(List<N> nodes, List<A> edges, Map<String, Object> annotations) {
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("List of nodes of a path must not be empty!");
        }
        if (edges == null || nodes.size() != edges.size() + 1) {
            throw new IllegalArgumentException("Number of edges must be exactly one less than the one of nodes! Number of nodes: " + nodes.size() + ". Edges: " + (edges != null ? Integer.valueOf(edges.size()) : null));
        }
        this.nodes = nodes;
        this.edges = edges;
        this.annotations = annotations;
    }

    public List<N> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public List<A> getArcs() {
        return this.edges != null ? Collections.unmodifiableList(this.edges) : null;
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotation(String key, Object value) {
        this.annotations.put(key, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.nodes).append(this.edges).append(this.annotations).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchGraphPath other = (SearchGraphPath)obj;
        return new EqualsBuilder().append(this.nodes, other.nodes).append(this.edges, other.edges).isEquals();
    }

    public String toString() {
        return "SearchGraphPath [nodes=" + this.nodes + ", edges=" + this.edges + ", annotations=" + this.annotations + "]";
    }

    public N getRoot() {
        return this.nodes.get(0);
    }

    public N getHead() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    public SearchGraphPath<N, A> getPathToParentOfHead() {
        if (this.nodes.isEmpty()) {
            throw new UnsupportedOperationException("This is an empty path!");
        }
        if (this.isPoint()) {
            throw new UnsupportedOperationException("Root has no head!");
        }
        return new SearchGraphPath<N, A>(this.nodes.subList(0, this.nodes.size() - 1), this.edges.subList(0, this.edges.size() - 1));
    }

    public boolean isPoint() {
        return this.nodes.size() == 1;
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public ILabeledPath<N, A> getPathFromChildOfRoot() {
        return new SearchGraphPath<N, A>(this.nodes.subList(1, this.nodes.size()), this.edges != null ? this.edges.subList(1, this.edges.size()) : null);
    }

    public A getInArc(N node) {
        return this.edges.get(this.nodes.indexOf(node) - 1);
    }

    public A getOutArc(N node) {
        return this.edges.get(this.nodes.indexOf(node));
    }

    public boolean containsNode(N node) {
        return this.nodes.contains(node);
    }

    public ILabeledPath<N, A> getUnmodifiableAccessor() {
        return new ReadOnlyPathAccessor((ILabeledPath)this);
    }

    public N getParentOfHead() {
        return this.nodes.get(this.nodes.size() - 2);
    }

    public void extend(N newHead, A arcToNewHead) {
        this.nodes.add(newHead);
        this.edges.add(arcToNewHead);
    }

    public void cutHead() {
        if (this.isPoint()) {
            throw new NoSuchElementException("The path consists only of one point, which cannot be removed.");
        }
        this.nodes.remove(this.nodes.size() - 1);
        this.edges.remove(this.edges.size() - 1);
    }
}

