/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.model.travesaltree;

import ai.libs.jaicore.graph.ReadOnlyPathAccessor;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.ENodeAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IEvaluatedPath;
import org.api4.java.datastructure.graph.ILabeledPath;

public class BackPointerPath<N, A, V extends Comparable<V>>
implements IEvaluatedPath<N, A, V> {
    private final N nodeLabel;
    private final A edgeLabelToParent;
    private boolean goal;
    protected BackPointerPath<N, A, V> parent;
    private final Map<String, Object> annotations = new HashMap<String, Object>();

    public BackPointerPath(N point) {
        this(null, point, null);
    }

    public BackPointerPath(BackPointerPath<N, A, V> parent, N point, A edgeLabelToParent) {
        this.parent = parent;
        this.nodeLabel = point;
        this.edgeLabelToParent = edgeLabelToParent;
    }

    public BackPointerPath<N, A, V> getParent() {
        return this.parent;
    }

    public N getHead() {
        return this.nodeLabel;
    }

    public V getScore() {
        return (V)((Comparable)this.annotations.get(ENodeAnnotation.F_SCORE.toString()));
    }

    public void setParent(BackPointerPath<N, A, V> newParent) {
        this.parent = newParent;
    }

    public void setScore(V internalLabel) {
        this.setAnnotation(ENodeAnnotation.F_SCORE.toString(), internalLabel);
    }

    public void setAnnotation(String annotationName, Object annotationValue) {
        this.annotations.put(annotationName, annotationValue);
    }

    public Object getAnnotation(String annotationName) {
        return this.annotations.get(annotationName);
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public boolean isGoal() {
        return this.goal;
    }

    public void setGoal(boolean goal) {
        this.goal = goal;
    }

    public List<BackPointerPath<N, A, V>> path() {
        ArrayList<BackPointerPath<N, A, V>> path = new ArrayList<BackPointerPath<N, A, V>>();
        BackPointerPath<N, A, V> current = this;
        while (current != null) {
            path.add(0, current);
            current = current.parent;
        }
        return path;
    }

    public List<N> getNodes() {
        ArrayList<N> path = new ArrayList<N>();
        BackPointerPath<N, A, V> current = this;
        while (current != null) {
            path.add(0, current.nodeLabel);
            current = current.parent;
        }
        return path;
    }

    public String getString() {
        String s = "Node [ref=";
        s = s + this.toString();
        s = s + ", externalLabel=";
        s = s + this.nodeLabel;
        s = s + ", goal";
        s = s + this.goal;
        s = s + ", parentRef=";
        s = this.parent != null ? s + this.parent.toString() : s + "null";
        s = s + ", annotations=";
        s = s + this.annotations;
        s = s + "]";
        return s;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("externalLabel", this.nodeLabel);
        fields.put("goal", this.goal);
        fields.put(ENodeAnnotation.F_SCORE.name(), this.getScore());
        fields.put(ENodeAnnotation.F_ERROR.name(), this.annotations.get(ENodeAnnotation.F_ERROR.name()));
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    public List<A> getArcs() {
        if (this.parent == null) {
            return new LinkedList();
        }
        List<A> pathToHere = this.parent.getArcs();
        pathToHere.add(this.edgeLabelToParent);
        return pathToHere;
    }

    public A getEdgeLabelToParent() {
        return this.edgeLabelToParent;
    }

    public N getRoot() {
        return this.parent == null ? this.nodeLabel : this.parent.getRoot();
    }

    public BackPointerPath<N, A, V> getPathToParentOfHead() {
        return this.parent;
    }

    public int getNumberOfNodes() {
        return this.parent == null ? 1 : this.parent.getNumberOfNodes() + 1;
    }

    public boolean isPoint() {
        return this.parent == null;
    }

    public BackPointerPath<N, A, V> getPathFromChildOfRoot() {
        if (this.parent.getParent() == null) {
            return new BackPointerPath<N, A, V>(this.nodeLabel);
        }
        return new BackPointerPath<N, A, V>(this.parent.getPathFromChildOfRoot(), this.nodeLabel, this.edgeLabelToParent);
    }

    public A getInArc(N node) {
        if (this.nodeLabel.equals(node)) {
            return this.edgeLabelToParent;
        }
        return this.parent.getInArc(node);
    }

    public A getOutArc(N node) {
        if (this.parent == null) {
            throw new NoSuchElementException("No such node found.");
        }
        if (this.parent.nodeLabel.equals(node)) {
            return this.edgeLabelToParent;
        }
        return this.parent.getOutArc(node);
    }

    public boolean containsNode(N node) {
        return this.nodeLabel.equals(node) || this.parent != null && this.parent.containsNode(node);
    }

    public ILabeledPath<N, A> getUnmodifiableAccessor() {
        return new ReadOnlyPathAccessor((ILabeledPath)this);
    }

    public N getParentOfHead() {
        return this.parent.getHead();
    }

    public void extend(N newHead, A arcToNewHead) {
        throw new UnsupportedOperationException("To assure consistency, back-pointer paths do not support modifications.");
    }

    public void cutHead() {
        throw new UnsupportedOperationException("To assure consistency, back-pointer paths do not support modifications.");
    }
}

