/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.model.travesaltree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.IRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class ReducedGraphGenerator<T, A>
implements IGraphGenerator<T, A> {
    private IGraphGenerator<T, A> basis;

    public ReducedGraphGenerator(IGraphGenerator<T, A> basis) {
        this.basis = basis;
    }

    public IRootGenerator<T> getRootGenerator() {
        return this.basis.getRootGenerator();
    }

    public ISuccessorGenerator<T, A> getSuccessorGenerator() {
        return new ISuccessorGenerator<T, A>(){
            private ISuccessorGenerator<T, A> generator;
            {
                this.generator = ReducedGraphGenerator.this.basis.getSuccessorGenerator();
            }

            public INewNodeDescription<T, A> reduce(INewNodeDescription<T, A> node) throws InterruptedException {
                List sucessors = this.generator.generateSuccessors(node.getTo());
                List previous = Arrays.asList(node);
                while (sucessors.size() == 1) {
                    previous = sucessors;
                    sucessors = this.generator.generateSuccessors(((INewNodeDescription)sucessors.get(0)).getTo());
                }
                return (INewNodeDescription)previous.get(0);
            }

            public List<INewNodeDescription<T, A>> generateSuccessors(T node) throws InterruptedException {
                List successors = this.generator.generateSuccessors(node);
                while (successors.size() == 1) {
                    List previous = successors;
                    if (!(successors = this.generator.generateSuccessors(((INewNodeDescription)successors.get(0)).getTo())).isEmpty()) continue;
                    return previous;
                }
                ArrayList reducedSuccessors = new ArrayList();
                for (INewNodeDescription successor : successors) {
                    reducedSuccessors.add(this.reduce(successor));
                }
                return reducedSuccessors;
            }
        };
    }
}

