/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.probleminputs;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.search.probleminputs.IMDP;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public abstract class AMDP<N, A, V extends Comparable<V>>
implements IMDP<N, A, V> {
    private final N initState;

    protected AMDP(N initState) {
        this.initState = initState;
    }

    @Override
    public N getInitState() {
        return this.initState;
    }

    @Override
    public double getProb(N state, A action, N successor) throws InterruptedException {
        return this.getProb(state, action, successor, false);
    }

    public double getProb(N state, A action, N successor, boolean setProbabilityOfUndefinedToZero) throws InterruptedException {
        Map<N, Double> dist = this.getProb(state, action);
        if (!dist.containsKey(successor)) {
            if (setProbabilityOfUndefinedToZero) {
                return 0.0;
            }
            throw new IllegalArgumentException("No probability defined for the following triplet:\n\tFrom state: " + state + "\n\tUsed action: " + action + "\n\tTo state: " + successor + ".\nDistribution is: " + dist.entrySet().stream().map(e -> "\n\t" + e.toString()).collect(Collectors.joining()));
        }
        return dist.get(successor);
    }

    @Override
    public boolean isTerminalState(N state) throws InterruptedException {
        return this.getApplicableActions(state).isEmpty();
    }

    @Override
    public A getUniformlyRandomApplicableAction(N state, Random random) throws InterruptedException {
        return (A)SetUtil.getRandomElement(this.getApplicableActions(state), (Random)random);
    }

    @Override
    public boolean isActionApplicableInState(N state, A action) throws InterruptedException {
        return this.getApplicableActions(state).contains(action);
    }
}

