/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.probleminputs;

import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.Iterator;
import java.util.List;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;

public class GraphSearchWithNumberBasedAdditivePathEvaluation<N, A>
extends GraphSearchWithSubpathEvaluationsInput<N, A, Double> {
    public GraphSearchWithNumberBasedAdditivePathEvaluation(IPathSearchInput<N, A> baseProblem, EdgeCostComputer<N, A> g, IPathEvaluator<N, A, Double> h) {
        this(baseProblem.getGraphGenerator(), baseProblem.getGoalTester(), new FComputer<N, A>(g, h));
    }

    public GraphSearchWithNumberBasedAdditivePathEvaluation(IGraphGenerator<N, A> graphGenerator, IPathGoalTester<N, A> goalTester, EdgeCostComputer<N, A> g, IPathEvaluator<N, A, Double> h) {
        this(graphGenerator, goalTester, new FComputer<N, A>(g, h));
    }

    public GraphSearchWithNumberBasedAdditivePathEvaluation(IPathSearchInput<N, A> baseProblem, FComputer<N, A> fComputer) {
        this(baseProblem.getGraphGenerator(), baseProblem.getGoalTester(), fComputer);
    }

    public GraphSearchWithNumberBasedAdditivePathEvaluation(IGraphGenerator<N, A> graphGenerator, IPathGoalTester<N, A> goalTester, FComputer<N, A> fComputer) {
        super(graphGenerator, goalTester, fComputer);
    }

    public static class FComputer<N, A>
    implements IPathEvaluator<N, A, Double> {
        private final EdgeCostComputer<N, A> g;
        private final IPathEvaluator<N, A, Double> h;

        public FComputer(EdgeCostComputer<N, A> g, IPathEvaluator<N, A, Double> h) {
            this.g = g;
            this.h = h;
        }

        public Double evaluate(ILabeledPath<N, A> path) throws PathEvaluationException, InterruptedException {
            if (!(path instanceof BackPointerPath)) {
                throw new IllegalArgumentException("Can compute f-value only for back pointer paths.");
            }
            List cPath = ((BackPointerPath)path).path();
            int depth = cPath.size() - 1;
            double pathCost = 0.0;
            double heuristic = (Double)this.h.evaluate(path);
            if (depth > 0) {
                Iterator it = cPath.iterator();
                BackPointerPath parent = it.next();
                while (it.hasNext()) {
                    BackPointerPath current = it.next();
                    pathCost += this.g.g(parent, current);
                    parent = current;
                }
            }
            return pathCost + heuristic;
        }

        public EdgeCostComputer<N, A> getG() {
            return this.g;
        }

        public IPathEvaluator<N, A, Double> getH() {
            return this.h;
        }
    }

    public static interface EdgeCostComputer<N, A> {
        public double g(BackPointerPath<N, A, ?> var1, BackPointerPath<N, A, ?> var2);
    }
}

