/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.probleminputs;

import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import java.util.HashMap;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.common.attributedobjects.IObjectEvaluator;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSearchWithPathEvaluationsInput<N, A, V extends Comparable<V>>
extends GraphSearchInput<N, A>
implements IPathSearchWithPathEvaluationsInput<N, A, V> {
    private final IPathEvaluator<N, A, V> pathEvaluator;

    public GraphSearchWithPathEvaluationsInput(IPathSearchInput<N, A> graphSearchInput, IPathEvaluator<N, A, V> pathEvaluator) {
        super(graphSearchInput);
        this.pathEvaluator = pathEvaluator;
    }

    public GraphSearchWithPathEvaluationsInput(IPathSearchInput<N, A> graphSearchInput, IObjectEvaluator<ILabeledPath<N, A>, V> pathEvaluator) {
        this(graphSearchInput, (IPathEvaluator<N, A, V>)(pathEvaluator instanceof IPathEvaluator ? (IPathEvaluator)pathEvaluator : new Evaluator<N, A, V>(pathEvaluator)));
    }

    public GraphSearchWithPathEvaluationsInput(IGraphGenerator<N, A> graphGenerator, IPathGoalTester<N, A> goalTester, IObjectEvaluator<ILabeledPath<N, A>, V> pathEvaluator) {
        this(new GraphSearchInput<N, A>(graphGenerator, goalTester), pathEvaluator);
    }

    public IPathEvaluator<N, A, V> getPathEvaluator() {
        return this.pathEvaluator;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("pathEvaluator", this.pathEvaluator);
        fields.put("graphGenerator", super.getGraphGenerator());
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    private static class Evaluator<N, A, V extends Comparable<V>>
    implements IPathEvaluator<N, A, V>,
    ILoggingCustomizable {
        private Logger logger = LoggerFactory.getLogger(Evaluator.class);
        private final IObjectEvaluator<ILabeledPath<N, A>, V> pathEvaluator;

        public Evaluator(IObjectEvaluator<ILabeledPath<N, A>, V> pathEvaluator) {
            if (pathEvaluator instanceof IPathEvaluator) {
                throw new IllegalArgumentException("An object of type " + IPathEvaluator.class.getName() + " should not be wrapped here!");
            }
            this.pathEvaluator = pathEvaluator;
        }

        public V evaluate(ILabeledPath<N, A> path) throws PathEvaluationException, InterruptedException {
            try {
                this.logger.info("Forwarding query for path of length {} to {}", (Object)path.getNumberOfNodes(), (Object)this.pathEvaluator.getClass().getName());
                return (V)this.pathEvaluator.evaluate(path);
            }
            catch (ObjectEvaluationFailedException e) {
                throw new PathEvaluationException(e.getMessage(), e.getCause());
            }
        }

        public String getLoggerName() {
            return this.logger.getName();
        }

        public void setLoggerName(String name) {
            this.logger = LoggerFactory.getLogger((String)name);
            if (this.pathEvaluator instanceof ILoggingCustomizable) {
                ((ILoggingCustomizable)this.pathEvaluator).setLoggerName(name + ".fw");
            }
        }
    }
}

