/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.probleminputs.builders;

import ai.libs.jaicore.search.model.other.SearchGraphPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.IRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public abstract class SearchProblemInputBuilder<N, A, I extends IPathSearchInput<N, A>, B extends SearchProblemInputBuilder<N, A, I, B>> {
    private IRootGenerator<N> rootGenerator;
    private ISuccessorGenerator<N, A> successorGenerator;
    private IPathGoalTester<N, A> goalTester;
    private ILabeledPath<N, A> prefixPath;

    public B withGraphGenerator(IGraphGenerator<N, A> graphGenerator) {
        this.rootGenerator = graphGenerator.getRootGenerator();
        this.successorGenerator = graphGenerator.getSuccessorGenerator();
        return this.self();
    }

    public IGraphGenerator<N, A> getGraphGenerator() {
        return new IGraphGenerator<N, A>(){

            public IRootGenerator<N> getRootGenerator() {
                return SearchProblemInputBuilder.this.rootGenerator;
            }

            public ISuccessorGenerator<N, A> getSuccessorGenerator() {
                return SearchProblemInputBuilder.this.successorGenerator;
            }
        };
    }

    public B fromProblem(IPathSearchInput<N, A> problem) {
        this.withGraphGenerator(problem.getGraphGenerator());
        this.withGoalTester(problem.getGoalTester());
        return this.self();
    }

    public B withRoot(N root) {
        this.rootGenerator = () -> Arrays.asList(root);
        return this.self();
    }

    public void withSuccessorGenerator(ISuccessorGenerator<N, A> successorGenerator) {
        this.successorGenerator = successorGenerator;
    }

    public B withOffsetRoot(List<Integer> indicesOfSuccessorsFromCurrentRoot) throws InterruptedException {
        if (this.rootGenerator == null) {
            throw new IllegalStateException("Cannot offset root when currently no root is set.");
        }
        if (this.successorGenerator == null) {
            throw new IllegalStateException("Cannot offset root when currently no successor generator is set.");
        }
        Collection roots = this.rootGenerator.getRoots();
        if (roots.size() > 1) {
            throw new IllegalStateException("Root offset is a function that is only reasonably defined for problems with one root!");
        }
        ArrayList prefixNodes = new ArrayList();
        ArrayList<Object> prefixArcs = new ArrayList<Object>();
        Object current = roots.iterator().next();
        prefixNodes.add(current);
        for (int child : indicesOfSuccessorsFromCurrentRoot) {
            INewNodeDescription ned = (INewNodeDescription)this.successorGenerator.generateSuccessors(current).get(child);
            current = ned.getTo();
            prefixArcs.add(ned.getArcLabel());
            prefixNodes.add(current);
        }
        this.prefixPath = new SearchGraphPath(prefixNodes, prefixArcs);
        this.rootGenerator = new ISingleRootGenerator<N>(){

            public N getRoot() {
                return SearchProblemInputBuilder.this.prefixPath.getHead();
            }
        };
        return this.self();
    }

    public ILabeledPath<N, A> getPrefixPath() {
        return this.prefixPath;
    }

    public B withGoalTester(IPathGoalTester<N, A> goalTester) {
        this.goalTester = goalTester;
        return this.self();
    }

    public IPathGoalTester<N, A> getGoalTester() {
        return this.goalTester;
    }

    public abstract I build();

    protected abstract B self();
}

