/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.problemtransformers;

import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.AlternativeNodeEvaluator;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.CoveringNodeEvaluator;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.RandomCompletionBasedNodeEvaluator;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import ai.libs.jaicore.search.problemtransformers.GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformer;
import java.util.Random;
import java.util.function.Predicate;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;

public class GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS<N, A, V extends Comparable<V>>
extends GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformer<N, A, V> {
    private final IPathEvaluator<N, A, V> preferredNodeEvaluator;
    private final Predicate<N> prioritizedNodesInRandomCompletion;
    private IPathEvaluator<N, A, V> coveringNodeEvaluator;
    private final Random random;
    private final int numSamples;
    private final int timeoutForSingleCompletionEvaluationInMS;
    private final int timeoutForNodeEvaluationInMS;

    public GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS(IPathEvaluator<N, A, V> preferredNodeEvaluator, Predicate<N> prioritizedNodesInRandomCompletion, Random random, int numSamples, int timeoutForSingleCompletionEvaluationInMS, int timeoutForNodeEvaluationInMS) {
        if (numSamples <= 0) {
            throw new IllegalArgumentException("Sample size has been set to " + numSamples + " but must be strictly positive!");
        }
        this.preferredNodeEvaluator = preferredNodeEvaluator;
        this.prioritizedNodesInRandomCompletion = prioritizedNodesInRandomCompletion;
        this.random = random;
        this.numSamples = numSamples;
        this.timeoutForSingleCompletionEvaluationInMS = timeoutForSingleCompletionEvaluationInMS;
        this.timeoutForNodeEvaluationInMS = timeoutForNodeEvaluationInMS;
    }

    public IPathEvaluator<N, A, V> getPreferredNodeEvaluator() {
        return this.preferredNodeEvaluator;
    }

    public Predicate<N> getPrioritizedNodePredicatesForRandomCompletion() {
        return this.prioritizedNodesInRandomCompletion;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    @Override
    public GraphSearchWithSubpathEvaluationsInput<N, A, V> encodeProblem(IPathSearchInput<N, A> problem) {
        if (!(problem instanceof IPathSearchWithPathEvaluationsInput)) {
            throw new IllegalArgumentException("Given problem must have path evaluation!");
        }
        IPathSearchWithPathEvaluationsInput cProblem = (IPathSearchWithPathEvaluationsInput)problem;
        RandomCompletionBasedNodeEvaluator rdfsNodeEvaluator = new RandomCompletionBasedNodeEvaluator(this.random, this.numSamples, this.numSamples * 2, cProblem.getPathEvaluator(), this.timeoutForSingleCompletionEvaluationInMS, this.timeoutForNodeEvaluationInMS, this.prioritizedNodesInRandomCompletion);
        Object mainEvaluator = this.coveringNodeEvaluator != null ? new CoveringNodeEvaluator(rdfsNodeEvaluator, this.coveringNodeEvaluator) : rdfsNodeEvaluator;
        if (this.preferredNodeEvaluator != null) {
            this.setNodeEvaluator(new AlternativeNodeEvaluator<N, A, V>(this.preferredNodeEvaluator, mainEvaluator));
        } else {
            this.setNodeEvaluator(mainEvaluator);
        }
        return super.encodeProblem(problem);
    }

    public IPathEvaluator<N, A, V> getCoveringNodeEvaluator() {
        return this.coveringNodeEvaluator;
    }

    public void setCoveringNodeEvaluator(IPathEvaluator<N, A, V> coveringNodeEvaluator) {
        this.coveringNodeEvaluator = coveringNodeEvaluator;
    }
}

