/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.graphmodels.balanced;

import ai.libs.jaicore.basic.MappingIterator;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ILazySuccessorGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;

public class BalancedGraphGeneratorGenerator {
    private final int branchingFactor;
    private final int maxDepth;

    public static int getNumberOfLeafsUnderANonTerminalNodeInDepth(int depthOfRequestedNode, int branchingFactor, int assumedDepthOfTree) {
        return (int)Math.pow(branchingFactor, (double)assumedDepthOfTree - (double)depthOfRequestedNode);
    }

    public static BigInteger getNumberOfMaxSubtreesOfMaxLengthUnderNonTerminalNodeInDepth(int depth, BigInteger maxNumberOfNodes, int branchingFactor, int maxDepth) {
        if (depth >= maxDepth) {
            throw new IllegalArgumentException("A node in depth " + depth + " in a graph with max depth " + maxDepth + " cannot be an inner nodee!");
        }
        int height = 0;
        BigInteger numberOfNodesForHeight = BigInteger.ONE;
        while (numberOfNodesForHeight.compareTo(maxNumberOfNodes) <= 0 && height < maxDepth) {
            numberOfNodesForHeight = BigInteger.valueOf(branchingFactor).pow(++height);
        }
        int missingLayers = maxDepth - depth;
        return BigInteger.valueOf(branchingFactor).pow(missingLayers - --height);
    }

    public BigInteger getNumberOfMaxSubtreesOfMaxLengthUnderNonTerminalNodeInDepth(int depth, BigInteger maxNumberOfNodes) {
        return BalancedGraphGeneratorGenerator.getNumberOfMaxSubtreesOfMaxLengthUnderNonTerminalNodeInDepth(depth, maxNumberOfNodes, this.branchingFactor, this.maxDepth);
    }

    public BalancedGraphGeneratorGenerator(int branchingFactor, int depth) {
        this.branchingFactor = branchingFactor;
        this.maxDepth = depth;
    }

    public IGraphGenerator<ITransparentTreeNode, Integer> create() {
        return new IGraphGenerator<ITransparentTreeNode, Integer>(){

            public ISingleRootGenerator<ITransparentTreeNode> getRootGenerator() {
                return () -> new BalancedTreeNode(0, BigInteger.ZERO);
            }

            public ILazySuccessorGenerator<ITransparentTreeNode, Integer> getSuccessorGenerator() {
                return new ILazySuccessorGenerator<ITransparentTreeNode, Integer>(){
                    private Map<ITransparentTreeNode, Set<Integer>> successors = new HashMap<ITransparentTreeNode, Set<Integer>>();

                    public List<INewNodeDescription<ITransparentTreeNode, Integer>> generateSuccessors(ITransparentTreeNode node) {
                        ArrayList<INewNodeDescription<ITransparentTreeNode, Integer>> successorsOfThisNode = new ArrayList<INewNodeDescription<ITransparentTreeNode, Integer>>();
                        int d = node.getDepth() + 1;
                        if (d > BalancedGraphGeneratorGenerator.this.maxDepth) {
                            return successorsOfThisNode;
                        }
                        for (int i = 0; i < BalancedGraphGeneratorGenerator.this.branchingFactor; ++i) {
                            successorsOfThisNode.add(this.generateSuccessor(node, i));
                        }
                        return successorsOfThisNode;
                    }

                    public NodeExpansionDescription<ITransparentTreeNode, Integer> generateSuccessor(ITransparentTreeNode node, int i) {
                        int j = i % BalancedGraphGeneratorGenerator.this.branchingFactor;
                        int d = node.getDepth() + 1;
                        BigInteger leftRelativesInGenerationOfNode = node.getNumberOfLeftRelativesInSameGeneration();
                        Objects.requireNonNull(leftRelativesInGenerationOfNode);
                        BigInteger offsetForIdOnLayer = BigInteger.valueOf(BalancedGraphGeneratorGenerator.this.branchingFactor).multiply(leftRelativesInGenerationOfNode);
                        BalancedTreeNode successor = new BalancedTreeNode(d, offsetForIdOnLayer.add(BigInteger.valueOf(j)));
                        this.successors.computeIfAbsent(node, n -> new HashSet()).add(j);
                        return new NodeExpansionDescription<ITransparentTreeNode, Integer>(successor, j);
                    }

                    public Iterator<INewNodeDescription<ITransparentTreeNode, Integer>> getIterativeGenerator(ITransparentTreeNode node) {
                        return new MappingIterator((Iterator)IntStream.range(0, BalancedGraphGeneratorGenerator.this.branchingFactor).iterator(), i -> this.generateSuccessor(node, (int)i));
                    }
                };
            }
        };
    }

    public class BalancedTreeNode
    implements ITransparentTreeNode {
        protected final int depth;
        protected final BigInteger idOfNodeOnLayer;

        public BalancedTreeNode(int depth, BigInteger idOfNodeOnLayer) {
            this.depth = depth;
            this.idOfNodeOnLayer = idOfNodeOnLayer;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + this.depth;
            result = 31 * result + (this.idOfNodeOnLayer == null ? 0 : this.idOfNodeOnLayer.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BalancedTreeNode other = (BalancedTreeNode)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            if (this.depth != other.depth) {
                return false;
            }
            return !(this.idOfNodeOnLayer == null ? other.idOfNodeOnLayer != null : !this.idOfNodeOnLayer.equals(other.idOfNodeOnLayer));
        }

        public String toString() {
            return "N [depth=" + this.depth + ", idOfNodeOnLayer=" + this.idOfNodeOnLayer + "]";
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public BigInteger getNumberOfLeftRelativesInSameGeneration() {
            return this.idOfNodeOnLayer;
        }

        @Override
        public BigInteger getNumberOfRightRelativesInSameGeneration() {
            return BigInteger.valueOf(BalancedGraphGeneratorGenerator.this.branchingFactor).pow(this.depth).subtract(this.idOfNodeOnLayer).subtract(BigInteger.ONE);
        }

        @Override
        public BigInteger getNumberOfLeafsStemmingFromLeftRelativesInSameGeneration() {
            return this.getNumberOfLeafsUnderNode().multiply(this.getNumberOfLeftRelativesInSameGeneration());
        }

        @Override
        public BigInteger getNumberOfLeafsUnderNode() {
            return BigInteger.valueOf(BalancedGraphGeneratorGenerator.this.branchingFactor).pow(BalancedGraphGeneratorGenerator.this.maxDepth - this.depth);
        }

        @Override
        public BigInteger getNumberOfLeafsStemmingFromRightRelativesInSameGeneration() {
            return this.getNumberOfLeafsUnderNode().multiply(this.getNumberOfRightRelativesInSameGeneration());
        }

        @Override
        public int getDistanceToShallowestLeafUnderNode() {
            return BalancedGraphGeneratorGenerator.this.maxDepth - this.depth;
        }

        @Override
        public int getDistanceToDeepestLeafUnderNode() {
            return this.getDistanceToShallowestLeafUnderNode();
        }

        @Override
        public BigInteger getNumberOfSubtreesWithMaxNumberOfNodesPriorToThisNode(BigInteger maxNumberOfNodes) {
            return this.getNumberOfLeafsPriorToNodeViaDFS().divideAndRemainder(maxNumberOfNodes)[0];
        }

        @Override
        public BigInteger getNumberOfSubtreesWithMaxNumberOfNodes(BigInteger maxNumberOfNodes) {
            return BalancedGraphGeneratorGenerator.this.getNumberOfMaxSubtreesOfMaxLengthUnderNonTerminalNodeInDepth(this.depth, maxNumberOfNodes);
        }

        @Override
        public BigInteger getNumberOfLeafsPriorToNodeViaDFS() {
            if (this.depth == BalancedGraphGeneratorGenerator.this.maxDepth) {
                return this.getNumberOfLeftRelativesInSameGeneration();
            }
            return this.getNumberOfLeftRelativesInSameGeneration().multiply(BigInteger.valueOf(BalancedGraphGeneratorGenerator.getNumberOfLeafsUnderANonTerminalNodeInDepth(this.depth, BalancedGraphGeneratorGenerator.this.branchingFactor, BalancedGraphGeneratorGenerator.this.maxDepth)));
        }

        @Override
        public BigInteger getNumberOfLeafsInSubtreesWithMaxNumberOfNodesPriorToThisNode(BigInteger maxNumberOfNodes) {
            throw new UnsupportedOperationException();
        }

        private BalancedGraphGeneratorGenerator getEnclosingInstance() {
            return BalancedGraphGeneratorGenerator.this;
        }

        @Override
        public boolean hasChildren() {
            throw new UnsupportedOperationException();
        }
    }
}

