/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.graphmodels.balanced;

import ai.libs.jaicore.search.probleminputs.GraphSearchWithPathEvaluationsInput;
import ai.libs.jaicore.search.syntheticgraphs.ISyntheticTreasureIslandProblem;
import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import ai.libs.jaicore.search.syntheticgraphs.graphmodels.balanced.BalanceGraphSearchProblem;
import ai.libs.jaicore.search.syntheticgraphs.graphmodels.balanced.BalancedGraphGeneratorGenerator;
import ai.libs.jaicore.search.syntheticgraphs.islandmodels.IIslandModel;
import ai.libs.jaicore.search.syntheticgraphs.islandmodels.equalsized.EqualSizedIslandsModel;
import ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.noisymean.ChaoticMeansTreasureModel;
import java.math.BigInteger;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.datastructure.graph.ILabeledPath;

public class BalancedGraphSearchWithPathEvaluationsProblem
extends GraphSearchWithPathEvaluationsInput<ITransparentTreeNode, Integer, Double>
implements ISyntheticTreasureIslandProblem {
    private final int expectedNumberOfIslands;
    private final int numTreasures;
    private final IIslandModel islandModel;
    private final int exactIslandSize;
    private final ChaoticMeansTreasureModel treasureModel;

    public static IIslandModel getIslandModel(int branchingFactor, int depth, int distanceToIslands) {
        return new EqualSizedIslandsModel(BigInteger.valueOf((long)Math.pow(branchingFactor, (double)depth - (double)distanceToIslands)));
    }

    public static ChaoticMeansTreasureModel getTreasureModel(int branchingFactor, int depth, int distanceToIslands, int numberOfIslandsWithTreasure) {
        return new ChaoticMeansTreasureModel(numberOfIslandsWithTreasure, BalancedGraphSearchWithPathEvaluationsProblem.getIslandModel(branchingFactor, depth, distanceToIslands), 0L);
    }

    public BalancedGraphSearchWithPathEvaluationsProblem(int branchingFactor, int depth, int distanceToIslands, int numberOfIslandsWithTreasure) {
        super(new BalanceGraphSearchProblem(branchingFactor, depth), BalancedGraphSearchWithPathEvaluationsProblem.getTreasureModel(branchingFactor, depth, distanceToIslands, numberOfIslandsWithTreasure));
        this.numTreasures = numberOfIslandsWithTreasure;
        this.treasureModel = (ChaoticMeansTreasureModel)this.getPathEvaluator();
        this.treasureModel.setGraphSearchInput(this);
        this.islandModel = this.treasureModel.getIslandModel();
        this.expectedNumberOfIslands = (int)Math.pow(branchingFactor, distanceToIslands);
        this.exactIslandSize = BalancedGraphGeneratorGenerator.getNumberOfLeafsUnderANonTerminalNodeInDepth(distanceToIslands, branchingFactor, depth);
        if ((int)Math.pow(branchingFactor, (double)depth - (double)distanceToIslands) != this.exactIslandSize) {
            throw new IllegalStateException("Island size is not computed correctly.");
        }
    }

    @Override
    public IIslandModel getIslandModel() {
        return this.islandModel;
    }

    @Override
    public int getExpectedNumberOfIslands() {
        return this.expectedNumberOfIslands;
    }

    @Override
    public int getMaximumIslandSizes() {
        return this.exactIslandSize;
    }

    @Override
    public int getMinimumIslandSizes() {
        return this.exactIslandSize;
    }

    @Override
    public int getNumberOfTreasureIslands() {
        return this.numTreasures;
    }

    @Override
    public boolean isPathATreasure(ILabeledPath<ITransparentTreeNode, Integer> path) throws PathEvaluationException, InterruptedException {
        return this.treasureModel.isPathToTreasureIsland(path);
    }
}

