/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.graphmodels.degenerated;

import ai.libs.jaicore.basic.MappingIterator;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import ai.libs.jaicore.search.syntheticgraphs.ISyntheticGraphGeneratorBuilder;
import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ILazySuccessorGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;

public class DegeneratedGraphGeneratorGenerator
implements ISyntheticGraphGeneratorBuilder {
    private final Random random;
    private final int deadEndsPerGeneration;
    private final int branchingFactor;
    private final int maxDepth;

    public BigInteger getNumberOfLeafsUnderANonTerminalNodeInDepth(int depthOfRequestedNode, int assumedDepthOfTree) {
        if (depthOfRequestedNode > assumedDepthOfTree) {
            throw new IllegalArgumentException("Requested node must not be deeper than the assumed depth of the tree!");
        }
        int remainingDepth = assumedDepthOfTree - depthOfRequestedNode;
        BigInteger innerNodes = BigInteger.ZERO;
        for (int k = 0; k < remainingDepth; ++k) {
            innerNodes = innerNodes.add(BigInteger.valueOf((long)this.branchingFactor - (long)this.deadEndsPerGeneration).pow(k));
        }
        BigInteger innerDeadEndSolutions = innerNodes.multiply(BigInteger.valueOf(this.deadEndsPerGeneration));
        BigInteger additionalLeafsOnLastLevel = BigInteger.valueOf((long)this.branchingFactor - (long)this.deadEndsPerGeneration).pow(remainingDepth);
        return innerDeadEndSolutions.add(additionalLeafsOnLastLevel);
    }

    public BigInteger getNumberOfMaxSubtreesOfMaxLengthUnderNonTerminalNodeInDepth(int depth, BigInteger maxNumberOfNodes) {
        int height = 1;
        while (this.getNumberOfLeafsUnderANonTerminalNodeInDepth(this.maxDepth - height, this.maxDepth).compareTo(maxNumberOfNodes) <= 0) {
            ++height;
        }
        if (--height > this.maxDepth) {
            throw new IllegalStateException("The height of the subtree cannot be higher than the max depth of the tree.");
        }
        int depthOfLayer = this.maxDepth - height;
        if (depthOfLayer < depth) {
            return BigInteger.ZERO;
        }
        return this.getNumberOfLeafsUnderANonTerminalNodeInDepth(depth, depthOfLayer);
    }

    public BigInteger getMaxNumberOfLeafsInEverySubtreeWithLimitedNumberOfLeafs(BigInteger maxNumberOfNodes) {
        int heightFromBottom = 1;
        while (this.getNumberOfLeafsUnderANonTerminalNodeInDepth(this.maxDepth - heightFromBottom, this.maxDepth).compareTo(maxNumberOfNodes) <= 0) {
            ++heightFromBottom;
        }
        if (--heightFromBottom == 1 && this.getNumberOfLeafsUnderANonTerminalNodeInDepth(this.maxDepth - 1, this.maxDepth).compareTo(maxNumberOfNodes) > 0) {
            return BigInteger.ONE;
        }
        BigInteger maxLeafs = this.getNumberOfLeafsUnderANonTerminalNodeInDepth(this.maxDepth - heightFromBottom, this.maxDepth);
        if (maxLeafs.compareTo(maxNumberOfNodes) > 0) {
            throw new IllegalStateException("Cannot return a number that is bigger than the initially given limit.\nTo return: " + maxLeafs + "\nLimit: " + maxNumberOfNodes);
        }
        return maxLeafs;
    }

    public DegeneratedGraphGeneratorGenerator(Random random, int deadEndsPerGeneration, int branchingFactor, int maxDepth) {
        this.random = random;
        this.deadEndsPerGeneration = deadEndsPerGeneration;
        this.branchingFactor = branchingFactor;
        this.maxDepth = maxDepth;
    }

    @Override
    public IGraphGenerator<ITransparentTreeNode, Integer> build() {
        return new DegeneratedGraphGenerator();
    }

    public class DegeneratedGraphGenerator
    implements IGraphGenerator<ITransparentTreeNode, Integer> {
        public ISingleRootGenerator<ITransparentTreeNode> getRootGenerator() {
            return () -> new TreeNode(null, 0, BigInteger.ZERO, 0, BigInteger.ZERO, true, 0, BigInteger.ZERO);
        }

        public ILazySuccessorGenerator<ITransparentTreeNode, Integer> getSuccessorGenerator() {
            return new ILazySuccessorGenerator<ITransparentTreeNode, Integer>(){
                private Map<ITransparentTreeNode, Set<Integer>> successors = new HashMap<ITransparentTreeNode, Set<Integer>>();

                public List<INewNodeDescription<ITransparentTreeNode, Integer>> generateSuccessors(ITransparentTreeNode node) throws InterruptedException {
                    TreeNode tNode = (TreeNode)node;
                    ArrayList<INewNodeDescription<ITransparentTreeNode, Integer>> successorsOfThisNode = new ArrayList<INewNodeDescription<ITransparentTreeNode, Integer>>();
                    if (!tNode.hasChildren) {
                        return successorsOfThisNode;
                    }
                    int d = node.getDepth() + 1;
                    if (d > DegeneratedGraphGeneratorGenerator.this.maxDepth) {
                        return successorsOfThisNode;
                    }
                    Iterator<INewNodeDescription<ITransparentTreeNode, Integer>> it = this.getIterativeGenerator(node);
                    while (it.hasNext()) {
                        successorsOfThisNode.add(it.next());
                    }
                    return successorsOfThisNode;
                }

                private INewNodeDescription<ITransparentTreeNode, Integer> getSuccessor(ITransparentTreeNode node, int indexOfChild) {
                    TreeNode tNode = (TreeNode)node;
                    if (!tNode.hasChildren) {
                        throw new IllegalArgumentException("Node " + node + " has no children and, hence, cannot have any successor being generated.");
                    }
                    int j = indexOfChild % DegeneratedGraphGeneratorGenerator.this.branchingFactor;
                    int d = node.getDepth() + 1;
                    BigInteger offsetForIdOnLayer = tNode.numOfLeftRelativesThatHaveChildren.multiply(BigInteger.valueOf(DegeneratedGraphGeneratorGenerator.this.branchingFactor));
                    BigInteger numOfLeftRelativesThatHaveChildren = tNode.numOfLeftRelativesThatHaveChildren.multiply(BigInteger.valueOf((long)DegeneratedGraphGeneratorGenerator.this.branchingFactor - (long)DegeneratedGraphGeneratorGenerator.this.deadEndsPerGeneration));
                    int numOfLeftSiblingsThatHaveChildren = 0;
                    long numOfLeftSiblingsWithoutChildren = 0L;
                    for (int k = 0; k < j; ++k) {
                        if (!tNode.indicesOfChildrenWithoutChildren.contains(k)) {
                            ++numOfLeftSiblingsThatHaveChildren;
                            continue;
                        }
                        ++numOfLeftSiblingsWithoutChildren;
                    }
                    BigInteger numOfLeftSiblingsWithChildrenAsBigInt = BigInteger.valueOf(numOfLeftSiblingsThatHaveChildren);
                    numOfLeftRelativesThatHaveChildren = numOfLeftRelativesThatHaveChildren.add(numOfLeftSiblingsWithChildrenAsBigInt);
                    BigInteger numOfSolutionsOfEveryLeftSiblingWithChildren = DegeneratedGraphGeneratorGenerator.this.getNumberOfLeafsUnderANonTerminalNodeInDepth(d, DegeneratedGraphGeneratorGenerator.this.maxDepth);
                    BigInteger numOfSolutionsUnderLeftSiblings = numOfSolutionsOfEveryLeftSiblingWithChildren.multiply(numOfLeftSiblingsWithChildrenAsBigInt).add(BigInteger.valueOf(numOfLeftSiblingsWithoutChildren));
                    BigInteger numberOfSolutionsFoundByDFS = tNode.numberOfLeafsFoundByDFSWhenReachingThisNode.add(numOfSolutionsUnderLeftSiblings);
                    boolean hasChildren = !tNode.indicesOfChildrenWithoutChildren.contains(indexOfChild) && d < DegeneratedGraphGeneratorGenerator.this.maxDepth;
                    TreeNode successor = new TreeNode(tNode, d, offsetForIdOnLayer.add(BigInteger.valueOf(j)), j, numOfLeftRelativesThatHaveChildren, hasChildren, numOfLeftSiblingsThatHaveChildren, numberOfSolutionsFoundByDFS);
                    this.successors.computeIfAbsent(node, n -> new HashSet()).add(j);
                    return new NodeExpansionDescription<ITransparentTreeNode, Integer>(successor, j);
                }

                public Iterator<INewNodeDescription<ITransparentTreeNode, Integer>> getIterativeGenerator(ITransparentTreeNode node) {
                    return new MappingIterator((Iterator)IntStream.range(0, DegeneratedGraphGeneratorGenerator.this.branchingFactor).iterator(), i -> this.getSuccessor(node, (int)i));
                }
            };
        }

        public BigInteger getMaxNumberOfLeafsInEverySubtreeOfMaxLength(BigInteger maxNumberOfNodes) {
            return DegeneratedGraphGeneratorGenerator.this.getMaxNumberOfLeafsInEverySubtreeWithLimitedNumberOfLeafs(maxNumberOfNodes);
        }
    }

    public class TreeNode
    implements ITransparentTreeNode {
        protected TreeNode parent;
        protected int depth;
        protected Set<Integer> indicesOfChildrenWithoutChildren;
        protected int idOfNodeAmongChildren;
        protected BigInteger idOfNodeOnLayer;
        protected int numOfLeftSiblingsThatHaveChildren;
        protected BigInteger numOfLeftRelativesThatHaveChildren;
        protected BigInteger numberOfLeafsFoundByDFSWhenReachingThisNode;
        protected boolean hasChildren;

        public TreeNode(TreeNode parent, int depth, BigInteger idOfNodeOnLayer, int idOfNodeAmongChildren, BigInteger numOfLeftRelativesThatHaveChildren, boolean hasChildren, int numOfLeftSiblingsThatHaveChildren, BigInteger solutionsPriorToThisNodeViaDFS) {
            this.parent = parent;
            this.depth = depth;
            this.idOfNodeAmongChildren = idOfNodeAmongChildren;
            this.idOfNodeOnLayer = idOfNodeOnLayer;
            this.numOfLeftRelativesThatHaveChildren = numOfLeftRelativesThatHaveChildren;
            this.hasChildren = hasChildren;
            this.numOfLeftSiblingsThatHaveChildren = numOfLeftSiblingsThatHaveChildren;
            this.numberOfLeafsFoundByDFSWhenReachingThisNode = solutionsPriorToThisNodeViaDFS;
            this.indicesOfChildrenWithoutChildren = new HashSet<Integer>();
            if (hasChildren) {
                while (this.indicesOfChildrenWithoutChildren.size() < DegeneratedGraphGeneratorGenerator.this.deadEndsPerGeneration) {
                    this.indicesOfChildrenWithoutChildren.add(DegeneratedGraphGeneratorGenerator.this.random.nextInt(DegeneratedGraphGeneratorGenerator.this.branchingFactor));
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.depth;
            result = 31 * result + this.idOfNodeOnLayer.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TreeNode other = (TreeNode)obj;
            if (this.depth != other.depth) {
                return false;
            }
            return this.idOfNodeOnLayer.equals(other.idOfNodeOnLayer);
        }

        public String toString() {
            return "N [depth=" + this.depth + ", idOfNodeOnLayer=" + this.idOfNodeOnLayer + "]";
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public BigInteger getNumberOfLeftRelativesInSameGeneration() {
            return this.idOfNodeOnLayer;
        }

        @Override
        public BigInteger getNumberOfLeafsPriorToNodeViaDFS() {
            return this.numberOfLeafsFoundByDFSWhenReachingThisNode;
        }

        @Override
        public BigInteger getNumberOfRightRelativesInSameGeneration() {
            return BigInteger.valueOf(DegeneratedGraphGeneratorGenerator.this.branchingFactor).pow(this.depth).subtract(this.idOfNodeOnLayer).subtract(BigInteger.valueOf(1L));
        }

        @Override
        public BigInteger getNumberOfLeafsStemmingFromLeftRelativesInSameGeneration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getNumberOfLeafsStemmingFromRightRelativesInSameGeneration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getNumberOfLeafsUnderNode() {
            if (!this.hasChildren) {
                return BigInteger.valueOf(1L);
            }
            return DegeneratedGraphGeneratorGenerator.this.getNumberOfLeafsUnderANonTerminalNodeInDepth(this.depth, DegeneratedGraphGeneratorGenerator.this.maxDepth);
        }

        @Override
        public int getDistanceToShallowestLeafUnderNode() {
            return 0;
        }

        @Override
        public int getDistanceToDeepestLeafUnderNode() {
            return DegeneratedGraphGeneratorGenerator.this.maxDepth - this.depth;
        }

        @Override
        public BigInteger getNumberOfSubtreesWithMaxNumberOfNodesPriorToThisNode(BigInteger maxNumberOfNodes) {
            if (this.parent == null) {
                return BigInteger.valueOf(0L);
            }
            BigInteger numSubtreesInducedByParentLevels = this.parent.getNumberOfSubtreesWithMaxNumberOfNodesPriorToThisNode(maxNumberOfNodes);
            if (this.parent.getNumberOfLeafsUnderNode().compareTo(maxNumberOfNodes) <= 0) {
                return numSubtreesInducedByParentLevels;
            }
            BigInteger maxNumberOfSubTreesForNonTerminalsOfThisDepth = DegeneratedGraphGeneratorGenerator.this.getNumberOfMaxSubtreesOfMaxLengthUnderNonTerminalNodeInDepth(this.depth, maxNumberOfNodes);
            BigInteger subTreesUnderLeftSiblings = maxNumberOfSubTreesForNonTerminalsOfThisDepth.multiply(BigInteger.valueOf(this.numOfLeftSiblingsThatHaveChildren));
            subTreesUnderLeftSiblings = subTreesUnderLeftSiblings.add(BigInteger.valueOf((long)this.idOfNodeAmongChildren - (long)this.numOfLeftSiblingsThatHaveChildren));
            return numSubtreesInducedByParentLevels.add(subTreesUnderLeftSiblings);
        }

        @Override
        public BigInteger getNumberOfLeafsInSubtreesWithMaxNumberOfNodesPriorToThisNode(BigInteger maxNumberOfNodes) {
            return DegeneratedGraphGeneratorGenerator.this.getMaxNumberOfLeafsInEverySubtreeWithLimitedNumberOfLeafs(maxNumberOfNodes).multiply(this.getNumberOfSubtreesWithMaxNumberOfNodesPriorToThisNode(maxNumberOfNodes));
        }

        @Override
        public BigInteger getNumberOfSubtreesWithMaxNumberOfNodes(BigInteger maxNumberOfNodes) {
            return DegeneratedGraphGeneratorGenerator.this.getNumberOfMaxSubtreesOfMaxLengthUnderNonTerminalNodeInDepth(this.depth, maxNumberOfNodes);
        }

        @Override
        public boolean hasChildren() {
            return this.hasChildren;
        }
    }
}

