/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.islandmodels.equalsized;

import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import ai.libs.jaicore.search.syntheticgraphs.islandmodels.IIslandModel;
import java.math.BigInteger;
import org.api4.java.datastructure.graph.ILabeledPath;

public class EqualSizedIslandsModel
implements IIslandModel {
    private final BigInteger size;
    private long numberOfIslands = -1L;
    private ITransparentTreeNode rootNode;

    public EqualSizedIslandsModel(int size) {
        this(BigInteger.valueOf(size));
    }

    public EqualSizedIslandsModel(BigInteger size) {
        this.size = size;
    }

    @Override
    public BigInteger getIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        return ((ITransparentTreeNode)path.getHead()).getNumberOfSubtreesWithMaxNumberOfNodesPriorToThisNode(this.size);
    }

    @Override
    public BigInteger getNumberOfIslands() {
        if (this.rootNode == null) {
            throw new IllegalStateException("Root has not been initialized yet!");
        }
        return this.rootNode.getNumberOfSubtreesWithMaxNumberOfNodes(this.size);
    }

    @Override
    public void setRootNode(ITransparentTreeNode root) {
        this.rootNode = root;
    }

    @Override
    public BigInteger getSizeOfIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        ILabeledPath currentPath = path;
        while (!currentPath.getArcs().isEmpty() && ((ITransparentTreeNode)currentPath.getPathToParentOfHead().getHead()).getNumberOfLeafsUnderNode().compareTo(this.size) <= 0) {
            currentPath = currentPath.getPathToParentOfHead();
        }
        BigInteger sizeOfThisIsland = ((ITransparentTreeNode)currentPath.getHead()).getNumberOfLeafsUnderNode();
        return sizeOfThisIsland;
    }

    @Override
    public BigInteger getPositionOnIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        return ((ITransparentTreeNode)path.getHead()).getNumberOfLeafsPriorToNodeViaDFS().subtract(((ITransparentTreeNode)path.getHead()).getNumberOfLeafsInSubtreesWithMaxNumberOfNodesPriorToThisNode(this.size));
    }
}

