/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.treasuremodels;

import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import ai.libs.jaicore.search.syntheticgraphs.treasuremodels.ITreasureModel;
import java.math.BigInteger;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinearTreasureModel
implements ITreasureModel {
    private Logger logger = LoggerFactory.getLogger(LinearTreasureModel.class);
    private final boolean asc;

    public LinearTreasureModel() {
        this(true);
    }

    public LinearTreasureModel(boolean asc) {
        this.asc = asc;
    }

    public Double evaluate(ILabeledPath<ITransparentTreeNode, Integer> path) throws PathEvaluationException, InterruptedException {
        BigInteger numLeafsBefore = ((ITransparentTreeNode)path.getHead()).getNumberOfLeafsPriorToNodeViaDFS();
        return this.asc ? numLeafsBefore.doubleValue() : ((ITransparentTreeNode)path.getRoot()).getNumberOfLeafsUnderNode().subtract(numLeafsBefore).doubleValue();
    }

    @Override
    public double getMinimumAchievable() {
        return 0.0;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public boolean isPathToTreasureIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        throw new UnsupportedOperationException();
    }
}

