/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands;

import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import ai.libs.jaicore.search.syntheticgraphs.islandmodels.IIslandModel;
import ai.libs.jaicore.search.syntheticgraphs.treasuremodels.ITreasureModel;
import java.math.BigInteger;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AIslandTreasureModel
implements ITreasureModel {
    private final IIslandModel islandModel;
    protected Logger logger = LoggerFactory.getLogger((String)("treasuremodel." + this.getClass().getName()));

    public AIslandTreasureModel(IIslandModel islandModel) {
        this.islandModel = islandModel;
    }

    public IIslandModel getIslandModel() {
        return this.islandModel;
    }

    public BigInteger getTotalNumberOfIslands() {
        return this.islandModel.getNumberOfIslands();
    }

    public BigInteger getPositionOnIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        return this.getIslandModel().getPositionOnIsland(path).add(BigInteger.ONE);
    }

    public BigInteger getIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        return this.getIslandModel().getIsland(path);
    }

    public BigInteger getIslandSize(ILabeledPath<ITransparentTreeNode, Integer> path) {
        return this.getIslandModel().getSizeOfIsland(path);
    }

    public void setLoggerName(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public String getLoggerName() {
        return this.logger.getName();
    }
}

