/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.funnel;

import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import ai.libs.jaicore.search.syntheticgraphs.islandmodels.IIslandModel;
import ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.AIslandTreasureModel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.datastructure.graph.ILabeledPath;

public class DominatedFunnelTreasureModel
extends AIslandTreasureModel {
    private final Random random;
    private final long seed;
    private final int numberOfTreasureIslands = 1;
    private final double plateauMin = 0.5;
    private final double maxPlateauAdvantageOfSubOptimals = 0.2;
    private double bestPlateauOfTreasures;
    private final double relativeInnerWidth = 0.1;
    private final double absSlopeOfInnerPlateau = 0.001;
    private final double relativeFunnelWidth = Math.pow(10.0, -10.0);
    private final Set<BigInteger> indicesOfTreasureIslands = new HashSet<BigInteger>();
    private final Map<BigInteger, Double> plateausOfIslands = new HashMap<BigInteger, Double>();

    public DominatedFunnelTreasureModel(IIslandModel islandModel, Random random) {
        super(islandModel);
        this.random = random;
        this.seed = random.nextLong();
    }

    private void distributeTreasures() {
        Random localRandom = new Random(this.seed);
        this.bestPlateauOfTreasures = Double.MAX_VALUE;
        while (this.indicesOfTreasureIslands.size() < this.numberOfTreasureIslands) {
            BigInteger newTreasureIsland;
            while ((newTreasureIsland = new BigInteger(this.getIslandModel().getNumberOfIslands().bitLength(), localRandom)).compareTo(this.getIslandModel().getNumberOfIslands()) >= 0) {
            }
            this.indicesOfTreasureIslands.add(newTreasureIsland);
        }
        for (BigInteger island : this.indicesOfTreasureIslands) {
            double plateauOfThisIsland = this.plateauMin + (0.9 - this.plateauMin) * localRandom.nextDouble();
            this.plateausOfIslands.put(island, plateauOfThisIsland);
            this.bestPlateauOfTreasures = Math.min(this.bestPlateauOfTreasures, plateauOfThisIsland);
        }
        this.logger.info("Treasure plateaus: {}. Treasure island: {}", (Object)this.getInnerPlateauOfTreasureIsland(this.bestPlateauOfTreasures), this.indicesOfTreasureIslands);
    }

    public Double evaluate(ILabeledPath<ITransparentTreeNode, Integer> path) throws PathEvaluationException, InterruptedException {
        double massOfBadPlateau;
        if (this.indicesOfTreasureIslands.isEmpty()) {
            this.getIslandModel().setRootNode((ITransparentTreeNode)path.getRoot());
            this.distributeTreasures();
        }
        BigInteger positionOnIsland = this.getPositionOnIsland(path);
        BigInteger island = this.getIsland(path);
        if (!this.plateausOfIslands.containsKey(island)) {
            this.plateausOfIslands.put(island, this.bestPlateauOfTreasures - this.maxPlateauAdvantageOfSubOptimals * (0.5 - new Random((long)path.hashCode() + this.seed).nextDouble()));
        }
        double plateauOfIsland = this.plateausOfIslands.get(island);
        if (!this.indicesOfTreasureIslands.contains(island)) {
            return plateauOfIsland;
        }
        BigInteger islandSize = this.getIsland(path);
        if (positionOnIsland.compareTo(islandSize) > 0) {
            throw new IllegalStateException("Position on island cannot be greater than the island itself.");
        }
        double relativePositionOnIsland = new BigDecimal(positionOnIsland).divide(new BigDecimal(islandSize)).doubleValue();
        if (relativePositionOnIsland < (massOfBadPlateau = 1.0 - this.relativeInnerWidth) / 2.0 || 1.0 - relativePositionOnIsland < massOfBadPlateau / 2.0) {
            return plateauOfIsland;
        }
        double marginOfFunnel = (1.0 - this.relativeFunnelWidth) / 2.0;
        if (relativePositionOnIsland < marginOfFunnel || 1.0 - relativePositionOnIsland < marginOfFunnel) {
            double relativePositionInInnerPlateau = (relativePositionOnIsland - massOfBadPlateau / 2.0) / this.relativeInnerWidth;
            if (relativePositionInInnerPlateau > 1.0) {
                throw new IllegalStateException();
            }
            double distanceToPlateauBorder = relativePositionInInnerPlateau < 0.5 ? relativePositionInInnerPlateau : 1.0 - relativePositionInInnerPlateau;
            double plateauMax = this.getInnerPlateauOfTreasureIsland(this.bestPlateauOfTreasures);
            return plateauMax - this.absSlopeOfInnerPlateau * distanceToPlateauBorder;
        }
        return this.random.nextDouble() * 0.1;
    }

    private double getInnerPlateauOfTreasureIsland(double nivel) {
        return nivel - 0.5 * this.maxPlateauAdvantageOfSubOptimals - 0.01;
    }

    @Override
    public double getMinimumAchievable() {
        return 0.0;
    }

    @Override
    public boolean isPathToTreasureIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        return this.indicesOfTreasureIslands.contains(this.getIsland(path));
    }
}

