/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.funnel;

import ai.libs.jaicore.math.linearalgebra.AffineFunction;
import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import ai.libs.jaicore.search.syntheticgraphs.islandmodels.IIslandModel;
import ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.AIslandTreasureModel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.datastructure.graph.ILabeledPath;

public class FunnelTreasureModel
extends AIslandTreasureModel {
    private final int numberOfTreasureIslands;
    private final Set<BigInteger> indicesOfIslands = new HashSet<BigInteger>();
    private final int seed;
    private final double plateauMinForTreasures;
    private final double plateauMaxForTreasures;
    private final double plateauMinForNonTreasures;
    private final double plateauMaxForNonTreasures;
    private final double plateauSizes;
    private final double funnelDepth;
    private double minimumAchievable = Double.MAX_VALUE;
    private final Map<BigInteger, Double> plateausOfIslands = new HashMap<BigInteger, Double>();

    public FunnelTreasureModel(IIslandModel islandModel, int numberOfTreasureIslands, int seed, double plateauMinForTreasures, double plateauMaxForTreasures, double plateauMinForNonTreasures, double plateauMaxForNonTreasures, double plateauSizes, double funnelDepth) {
        super(islandModel);
        this.numberOfTreasureIslands = numberOfTreasureIslands;
        this.seed = seed;
        this.plateauMinForTreasures = plateauMinForTreasures;
        this.plateauMaxForTreasures = plateauMaxForTreasures;
        this.plateauMinForNonTreasures = plateauMinForNonTreasures;
        this.plateauMaxForNonTreasures = plateauMaxForNonTreasures;
        this.plateauSizes = plateauSizes;
        this.funnelDepth = funnelDepth;
    }

    public FunnelTreasureModel(IIslandModel islandModel, int numberOfTreasureIslands, Random random) {
        this(islandModel, numberOfTreasureIslands, random.nextInt(), 0.1, 0.15, 0.7, 0.95, 0.5, 0.1);
    }

    private void distributeTreasures() {
        Random random = new Random(this.seed);
        while (this.indicesOfIslands.size() < this.numberOfTreasureIslands) {
            BigInteger newTreasureIsland;
            while ((newTreasureIsland = new BigInteger(this.getIslandModel().getNumberOfIslands().bitLength(), random)).compareTo(this.getIslandModel().getNumberOfIslands()) >= 0) {
            }
            this.indicesOfIslands.add(newTreasureIsland);
        }
        for (BigInteger island : this.indicesOfIslands) {
            double plateauOfThisIsland = this.plateauMinForTreasures + (this.plateauMaxForTreasures - this.plateauMinForTreasures) * random.nextDouble();
            this.plateausOfIslands.put(island, plateauOfThisIsland);
            this.minimumAchievable = Math.min(this.minimumAchievable, plateauOfThisIsland - this.funnelDepth);
        }
    }

    public Double evaluate(ILabeledPath<ITransparentTreeNode, Integer> path) throws PathEvaluationException, InterruptedException {
        BigDecimal median;
        BigDecimal c2;
        BigDecimal c1;
        if (this.indicesOfIslands.isEmpty()) {
            this.getIslandModel().setRootNode((ITransparentTreeNode)path.getRoot());
            this.distributeTreasures();
        }
        BigInteger positionOnIsland = this.getPositionOnIsland(path);
        BigInteger island = this.getIsland(path);
        if (!this.plateausOfIslands.containsKey(island)) {
            this.plateausOfIslands.put(island, this.plateauMinForNonTreasures + (this.plateauMaxForNonTreasures - this.plateauMinForNonTreasures) * new Random((long)path.hashCode() + (long)this.seed).nextDouble());
        }
        double plateauOfIsland = this.plateausOfIslands.get(island);
        BigInteger islandSize = this.getIsland(path);
        if (positionOnIsland.compareTo(islandSize) > 0) {
            throw new IllegalStateException("Position on island cannot be greater than the island itself.");
        }
        BigDecimal islandSizeAsDecimal = new BigDecimal(islandSize);
        if (islandSize.remainder(BigInteger.valueOf(2L)).equals(BigInteger.ZERO)) {
            c1 = islandSizeAsDecimal.multiply(BigDecimal.valueOf(this.plateauSizes / 2.0)).round(new MathContext(1, RoundingMode.CEILING));
            c2 = islandSizeAsDecimal.subtract(c1).round(new MathContext(1, RoundingMode.FLOOR));
            median = islandSizeAsDecimal.divide(BigDecimal.valueOf(2L));
        } else {
            c1 = islandSizeAsDecimal.multiply(BigDecimal.valueOf(this.plateauSizes / 2.0)).round(new MathContext(1, RoundingMode.FLOOR));
            c2 = islandSizeAsDecimal.subtract(islandSizeAsDecimal.multiply(BigDecimal.valueOf(this.plateauSizes / 2.0))).round(new MathContext(1, RoundingMode.CEILING)).add(BigDecimal.ONE);
            median = islandSizeAsDecimal.add(BigDecimal.ONE).divide(BigDecimal.valueOf(2L));
        }
        double val = positionOnIsland.compareTo(c1.toBigInteger()) <= 0 || positionOnIsland.compareTo(c2.toBigInteger()) > 0 ? plateauOfIsland : (positionOnIsland.compareTo(median.toBigInteger()) <= 0 ? new AffineFunction(c1, BigDecimal.valueOf(plateauOfIsland), median, BigDecimal.valueOf(plateauOfIsland).subtract(BigDecimal.valueOf(this.funnelDepth))).applyAsDouble((Number)positionOnIsland) : new AffineFunction(c2, BigDecimal.valueOf(plateauOfIsland), median, BigDecimal.valueOf(plateauOfIsland).subtract(BigDecimal.valueOf(this.funnelDepth))).applyAsDouble((Number)positionOnIsland));
        return val;
    }

    @Override
    public double getMinimumAchievable() {
        return this.minimumAchievable;
    }

    @Override
    public boolean isPathToTreasureIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        if (this.indicesOfIslands.isEmpty()) {
            this.getIslandModel().setRootNode((ITransparentTreeNode)path.getRoot());
            this.distributeTreasures();
        }
        return this.indicesOfIslands.contains(this.getIsland(path));
    }
}

