/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.noisymean;

import ai.libs.jaicore.search.algorithms.standard.random.RandomSearch;
import ai.libs.jaicore.search.syntheticgraphs.graphmodels.ITransparentTreeNode;
import ai.libs.jaicore.search.syntheticgraphs.islandmodels.IIslandModel;
import ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.noisymean.NoisyMeanTreasureModel;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.datastructure.graph.ILabeledPath;

public class ChaoticMeansTreasureModel
extends NoisyMeanTreasureModel {
    private final int numberOfIslandsWithTreasure;
    private final Map<BigInteger, Double> means = new HashMap<BigInteger, Double>();
    private final Random random;
    private final Set<BigInteger> indicesOfIslands = new HashSet<BigInteger>();
    private boolean treasuresDistributed = false;
    private IPathSearchInput<ITransparentTreeNode, Integer> graphSearchInput;

    public ChaoticMeansTreasureModel(int numberOfIslandsWithTreasure, IIslandModel islandModel, long seed) {
        this(numberOfIslandsWithTreasure, islandModel, new Random(seed));
    }

    public ChaoticMeansTreasureModel(int numberOfIslandsWithTreasure, IIslandModel islandModel, Random r) {
        super(islandModel);
        this.numberOfIslandsWithTreasure = numberOfIslandsWithTreasure;
        this.random = r;
    }

    private void distributeTreasures() throws AlgorithmTimeoutedException, InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException {
        if (this.graphSearchInput == null) {
            throw new IllegalStateException("Cannot distribute treasures before graph generator has been set.");
        }
        this.logger.info("Start treasure distribution. Will choose {} treasure islands.", (Object)this.numberOfIslandsWithTreasure);
        RandomSearch<ITransparentTreeNode, Integer> rs = new RandomSearch<ITransparentTreeNode, Integer>(this.graphSearchInput);
        while (this.indicesOfIslands.size() < this.numberOfIslandsWithTreasure) {
            ILabeledPath treasurePath = (ILabeledPath)rs.nextSolutionCandidate();
            this.indicesOfIslands.add(this.getIslandModel().getIsland((ILabeledPath<ITransparentTreeNode, Integer>)treasurePath));
        }
        if (this.indicesOfIslands.size() != this.numberOfIslandsWithTreasure) {
            throw new IllegalStateException("Treasure distribution failed! Distributed " + this.indicesOfIslands.size() + " instead of " + this.numberOfIslandsWithTreasure + " treasurs.");
        }
        this.logger.info("Defined {} treasure islands: {}", (Object)this.numberOfIslandsWithTreasure, this.indicesOfIslands);
        this.treasuresDistributed = true;
    }

    @Override
    public double getMeanOfIsland(BigInteger island) {
        if (this.indicesOfIslands.isEmpty()) {
            try {
                this.distributeTreasures();
            }
            catch (AlgorithmException | AlgorithmExecutionCanceledException | AlgorithmTimeoutedException e) {
                return Double.NaN;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return Double.NaN;
            }
        }
        Random r1 = new Random((long)this.random.nextInt() + (long)island.intValue());
        return this.means.computeIfAbsent(island, p -> this.isTreasureIsland((BigInteger)p) ? 1.0 + r1.nextDouble() * 5.0 : 20.0 + r1.nextDouble() * 85.0);
    }

    public boolean isTreasureIsland(BigInteger island) {
        if (this.indicesOfIslands.isEmpty()) {
            try {
                this.distributeTreasures();
            }
            catch (AlgorithmException | AlgorithmExecutionCanceledException | AlgorithmTimeoutedException e) {
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return this.indicesOfIslands.contains(island);
    }

    @Override
    public boolean isPathToTreasureIsland(ILabeledPath<ITransparentTreeNode, Integer> path) {
        return this.isTreasureIsland(this.getIslandModel().getIsland(path));
    }

    public Collection<BigInteger> getTreasureIslands() {
        return Collections.unmodifiableCollection(this.indicesOfIslands);
    }

    @Override
    public double getMinimumAchievable() {
        throw new UnsupportedOperationException();
    }

    public boolean isTreasuresDistributed() {
        return this.treasuresDistributed;
    }

    public IPathSearchInput<ITransparentTreeNode, Integer> getGraphSearchInput() {
        return this.graphSearchInput;
    }

    public void setGraphSearchInput(IPathSearchInput<ITransparentTreeNode, Integer> graphSearchInput) {
        this.graphSearchInput = graphSearchInput;
    }
}

