/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.noisymean;

import ai.libs.jaicore.search.syntheticgraphs.islandmodels.IIslandModel;
import ai.libs.jaicore.search.syntheticgraphs.treasuremodels.islands.noisymean.ATreasureMeanFunction;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ShiftedSineTreasureGenerator
extends ATreasureMeanFunction {
    private final double c;
    private final double d;

    public ShiftedSineTreasureGenerator(IIslandModel islandModel, long numberOfTreasures, double c, double d) {
        super(islandModel, numberOfTreasures);
        this.c = c;
        this.d = d;
    }

    @Override
    public Double apply(BigInteger t) {
        double max = (double)(this.getNumberOfTreasures() * 2L) * Math.PI;
        double positionInInterval = new BigDecimal(t).multiply(BigDecimal.valueOf(max)).divide(BigDecimal.valueOf(this.getTotalNumberOfIslands().intValue())).doubleValue();
        int periodOffset = (int)Math.floor(positionInInterval / (Math.PI * 2));
        double positionInPeriod = positionInInterval % (Math.PI * 2);
        double shiftedPosition = positionInPeriod < 0.5 * (Math.PI - this.c) ? (1.0 - this.d / (0.5 * (Math.PI - this.c))) * positionInPeriod : (positionInPeriod > 0.5 * (Math.PI + this.c) ? (1.0 - this.d / (Math.PI * 2 - 0.5 * (Math.PI + this.c))) * positionInPeriod + Math.PI * 2 * this.d / (Math.PI * 2 - 0.5 * (Math.PI + this.c)) : (1.0 + 2.0 * this.d / this.c) * positionInPeriod + this.d * ((this.c - Math.PI) / this.c - 1.0));
        return (-1.0 * Math.sin(shiftedPosition += Math.PI * 2 * (double)periodOffset) + 1.0) * 50.0;
    }
}

