/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.CCM_I21_PROBLEM_OBSERVATION;
import ca.uhn.hl7v2.model.v281.group.CCM_I21_ROLE_PROBLEM;
import ca.uhn.hl7v2.model.v281.segment.PRB;
import ca.uhn.hl7v2.model.v281.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCM_I21_PROBLEM
extends AbstractGroup {
    public CCM_I21_PROBLEM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PRB.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CCM_I21_ROLE_PROBLEM.class, false, true, false);
            this.add(CCM_I21_PROBLEM_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCM_I21_PROBLEM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PRB getPRB() {
        PRB retVal = (PRB)this.getTyped("PRB", PRB.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CCM_I21_ROLE_PROBLEM getROLE_PROBLEM() {
        CCM_I21_ROLE_PROBLEM retVal = (CCM_I21_ROLE_PROBLEM)this.getTyped("ROLE_PROBLEM", CCM_I21_ROLE_PROBLEM.class);
        return retVal;
    }

    public CCM_I21_ROLE_PROBLEM getROLE_PROBLEM(int rep) {
        CCM_I21_ROLE_PROBLEM retVal = (CCM_I21_ROLE_PROBLEM)this.getTyped("ROLE_PROBLEM", rep, CCM_I21_ROLE_PROBLEM.class);
        return retVal;
    }

    public int getROLE_PROBLEMReps() {
        return this.getReps("ROLE_PROBLEM");
    }

    public List<CCM_I21_ROLE_PROBLEM> getROLE_PROBLEMAll() throws HL7Exception {
        return this.getAllAsList("ROLE_PROBLEM", CCM_I21_ROLE_PROBLEM.class);
    }

    public void insertROLE_PROBLEM(CCM_I21_ROLE_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_PROBLEM", (Structure)structure, rep);
    }

    public CCM_I21_ROLE_PROBLEM insertROLE_PROBLEM(int rep) throws HL7Exception {
        return (CCM_I21_ROLE_PROBLEM)super.insertRepetition("ROLE_PROBLEM", rep);
    }

    public CCM_I21_ROLE_PROBLEM removeROLE_PROBLEM(int rep) throws HL7Exception {
        return (CCM_I21_ROLE_PROBLEM)super.removeRepetition("ROLE_PROBLEM", rep);
    }

    public CCM_I21_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION() {
        CCM_I21_PROBLEM_OBSERVATION retVal = (CCM_I21_PROBLEM_OBSERVATION)this.getTyped("PROBLEM_OBSERVATION", CCM_I21_PROBLEM_OBSERVATION.class);
        return retVal;
    }

    public CCM_I21_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION(int rep) {
        CCM_I21_PROBLEM_OBSERVATION retVal = (CCM_I21_PROBLEM_OBSERVATION)this.getTyped("PROBLEM_OBSERVATION", rep, CCM_I21_PROBLEM_OBSERVATION.class);
        return retVal;
    }

    public int getPROBLEM_OBSERVATIONReps() {
        return this.getReps("PROBLEM_OBSERVATION");
    }

    public List<CCM_I21_PROBLEM_OBSERVATION> getPROBLEM_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM_OBSERVATION", CCM_I21_PROBLEM_OBSERVATION.class);
    }

    public void insertPROBLEM_OBSERVATION(CCM_I21_PROBLEM_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_OBSERVATION", (Structure)structure, rep);
    }

    public CCM_I21_PROBLEM_OBSERVATION insertPROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (CCM_I21_PROBLEM_OBSERVATION)super.insertRepetition("PROBLEM_OBSERVATION", rep);
    }

    public CCM_I21_PROBLEM_OBSERVATION removePROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (CCM_I21_PROBLEM_OBSERVATION)super.removeRepetition("PROBLEM_OBSERVATION", rep);
    }
}

