/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.CCU_I20_MEDICATION_ENCODING_OBSERVATION;
import ca.uhn.hl7v2.model.v281.segment.RXC;
import ca.uhn.hl7v2.model.v281.segment.RXE;
import ca.uhn.hl7v2.model.v281.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCU_I20_MEDICATION_ENCODING_DETAIL
extends AbstractGroup {
    public CCU_I20_MEDICATION_ENCODING_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXE.class, true, false, false);
            this.add(RXR.class, true, true, false);
            this.add(RXC.class, false, true, false);
            this.add(CCU_I20_MEDICATION_ENCODING_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCU_I20_MEDICATION_ENCODING_DETAIL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public RXE getRXE() {
        RXE retVal = (RXE)this.getTyped("RXE", RXE.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC retVal = (RXC)this.getTyped("RXC", RXC.class);
        return retVal;
    }

    public RXC getRXC(int rep) {
        RXC retVal = (RXC)this.getTyped("RXC", rep, RXC.class);
        return retVal;
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public CCU_I20_MEDICATION_ENCODING_OBSERVATION getMEDICATION_ENCODING_OBSERVATION() {
        CCU_I20_MEDICATION_ENCODING_OBSERVATION retVal = (CCU_I20_MEDICATION_ENCODING_OBSERVATION)this.getTyped("MEDICATION_ENCODING_OBSERVATION", CCU_I20_MEDICATION_ENCODING_OBSERVATION.class);
        return retVal;
    }

    public CCU_I20_MEDICATION_ENCODING_OBSERVATION getMEDICATION_ENCODING_OBSERVATION(int rep) {
        CCU_I20_MEDICATION_ENCODING_OBSERVATION retVal = (CCU_I20_MEDICATION_ENCODING_OBSERVATION)this.getTyped("MEDICATION_ENCODING_OBSERVATION", rep, CCU_I20_MEDICATION_ENCODING_OBSERVATION.class);
        return retVal;
    }

    public int getMEDICATION_ENCODING_OBSERVATIONReps() {
        return this.getReps("MEDICATION_ENCODING_OBSERVATION");
    }

    public List<CCU_I20_MEDICATION_ENCODING_OBSERVATION> getMEDICATION_ENCODING_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("MEDICATION_ENCODING_OBSERVATION", CCU_I20_MEDICATION_ENCODING_OBSERVATION.class);
    }

    public void insertMEDICATION_ENCODING_OBSERVATION(CCU_I20_MEDICATION_ENCODING_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("MEDICATION_ENCODING_OBSERVATION", (Structure)structure, rep);
    }

    public CCU_I20_MEDICATION_ENCODING_OBSERVATION insertMEDICATION_ENCODING_OBSERVATION(int rep) throws HL7Exception {
        return (CCU_I20_MEDICATION_ENCODING_OBSERVATION)super.insertRepetition("MEDICATION_ENCODING_OBSERVATION", rep);
    }

    public CCU_I20_MEDICATION_ENCODING_OBSERVATION removeMEDICATION_ENCODING_OBSERVATION(int rep) throws HL7Exception {
        return (CCU_I20_MEDICATION_ENCODING_OBSERVATION)super.removeRepetition("MEDICATION_ENCODING_OBSERVATION", rep);
    }
}

