/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.EHC_E01_PATIENT_INFO;
import ca.uhn.hl7v2.model.v281.group.EHC_E01_PROCEDURE;
import ca.uhn.hl7v2.model.v281.group.EHC_E01_PRODUCT_SERVICE_LINE_ITEM;
import ca.uhn.hl7v2.model.v281.segment.IPR;
import ca.uhn.hl7v2.model.v281.segment.LOC;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.PSG;
import ca.uhn.hl7v2.model.v281.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E01_PRODUCT_SERVICE_GROUP
extends AbstractGroup {
    public EHC_E01_PRODUCT_SERVICE_GROUP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSG.class, true, false, true);
            this.add(LOC.class, false, true, true);
            this.add(PRT.class, false, true, true);
            this.add(ROL.class, false, true, true);
            this.add(EHC_E01_PATIENT_INFO.class, false, true, false);
            this.add(EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class, true, true, false);
            this.add(EHC_E01_PROCEDURE.class, false, true, false);
            this.add(IPR.class, false, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E01_PRODUCT_SERVICE_GROUP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PSG getPSG() {
        PSG retVal = (PSG)this.getTyped("PSG", PSG.class);
        return retVal;
    }

    public LOC getLOC() {
        LOC retVal = (LOC)this.getTyped("LOC", LOC.class);
        return retVal;
    }

    public LOC getLOC(int rep) {
        LOC retVal = (LOC)this.getTyped("LOC", rep, LOC.class);
        return retVal;
    }

    public int getLOCReps() {
        return this.getReps("LOC");
    }

    public List<LOC> getLOCAll() throws HL7Exception {
        return this.getAllAsList("LOC", LOC.class);
    }

    public void insertLOC(LOC structure, int rep) throws HL7Exception {
        super.insertRepetition("LOC", (Structure)structure, rep);
    }

    public LOC insertLOC(int rep) throws HL7Exception {
        return (LOC)super.insertRepetition("LOC", rep);
    }

    public LOC removeLOC(int rep) throws HL7Exception {
        return (LOC)super.removeRepetition("LOC", rep);
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ROL getROL() {
        ROL retVal = (ROL)this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = (ROL)this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public EHC_E01_PATIENT_INFO getPATIENT_INFO() {
        EHC_E01_PATIENT_INFO retVal = (EHC_E01_PATIENT_INFO)this.getTyped("PATIENT_INFO", EHC_E01_PATIENT_INFO.class);
        return retVal;
    }

    public EHC_E01_PATIENT_INFO getPATIENT_INFO(int rep) {
        EHC_E01_PATIENT_INFO retVal = (EHC_E01_PATIENT_INFO)this.getTyped("PATIENT_INFO", rep, EHC_E01_PATIENT_INFO.class);
        return retVal;
    }

    public int getPATIENT_INFOReps() {
        return this.getReps("PATIENT_INFO");
    }

    public List<EHC_E01_PATIENT_INFO> getPATIENT_INFOAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_INFO", EHC_E01_PATIENT_INFO.class);
    }

    public void insertPATIENT_INFO(EHC_E01_PATIENT_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_INFO", (Structure)structure, rep);
    }

    public EHC_E01_PATIENT_INFO insertPATIENT_INFO(int rep) throws HL7Exception {
        return (EHC_E01_PATIENT_INFO)super.insertRepetition("PATIENT_INFO", rep);
    }

    public EHC_E01_PATIENT_INFO removePATIENT_INFO(int rep) throws HL7Exception {
        return (EHC_E01_PATIENT_INFO)super.removeRepetition("PATIENT_INFO", rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM getPRODUCT_SERVICE_LINE_ITEM() {
        EHC_E01_PRODUCT_SERVICE_LINE_ITEM retVal = (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)this.getTyped("PRODUCT_SERVICE_LINE_ITEM", EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class);
        return retVal;
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM getPRODUCT_SERVICE_LINE_ITEM(int rep) {
        EHC_E01_PRODUCT_SERVICE_LINE_ITEM retVal = (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)this.getTyped("PRODUCT_SERVICE_LINE_ITEM", rep, EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class);
        return retVal;
    }

    public int getPRODUCT_SERVICE_LINE_ITEMReps() {
        return this.getReps("PRODUCT_SERVICE_LINE_ITEM");
    }

    public List<EHC_E01_PRODUCT_SERVICE_LINE_ITEM> getPRODUCT_SERVICE_LINE_ITEMAll() throws HL7Exception {
        return this.getAllAsList("PRODUCT_SERVICE_LINE_ITEM", EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class);
    }

    public void insertPRODUCT_SERVICE_LINE_ITEM(EHC_E01_PRODUCT_SERVICE_LINE_ITEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT_SERVICE_LINE_ITEM", (Structure)structure, rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM insertPRODUCT_SERVICE_LINE_ITEM(int rep) throws HL7Exception {
        return (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)super.insertRepetition("PRODUCT_SERVICE_LINE_ITEM", rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM removePRODUCT_SERVICE_LINE_ITEM(int rep) throws HL7Exception {
        return (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)super.removeRepetition("PRODUCT_SERVICE_LINE_ITEM", rep);
    }

    public EHC_E01_PROCEDURE getPROCEDURE() {
        EHC_E01_PROCEDURE retVal = (EHC_E01_PROCEDURE)this.getTyped("PROCEDURE", EHC_E01_PROCEDURE.class);
        return retVal;
    }

    public EHC_E01_PROCEDURE getPROCEDURE(int rep) {
        EHC_E01_PROCEDURE retVal = (EHC_E01_PROCEDURE)this.getTyped("PROCEDURE", rep, EHC_E01_PROCEDURE.class);
        return retVal;
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<EHC_E01_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", EHC_E01_PROCEDURE.class);
    }

    public void insertPROCEDURE(EHC_E01_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public EHC_E01_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (EHC_E01_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public EHC_E01_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (EHC_E01_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public IPR getIPR() {
        IPR retVal = (IPR)this.getTyped("IPR", IPR.class);
        return retVal;
    }

    public IPR getIPR(int rep) {
        IPR retVal = (IPR)this.getTyped("IPR", rep, IPR.class);
        return retVal;
    }

    public int getIPRReps() {
        return this.getReps("IPR");
    }

    public List<IPR> getIPRAll() throws HL7Exception {
        return this.getAllAsList("IPR", IPR.class);
    }

    public void insertIPR(IPR structure, int rep) throws HL7Exception {
        super.insertRepetition("IPR", (Structure)structure, rep);
    }

    public IPR insertIPR(int rep) throws HL7Exception {
        return (IPR)super.insertRepetition("IPR", rep);
    }

    public IPR removeIPR(int rep) throws HL7Exception {
        return (IPR)super.removeRepetition("IPR", rep);
    }
}

