/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.EAC_U07_COMMAND;
import ca.uhn.hl7v2.model.v281.segment.EQU;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EAC_U07
extends AbstractMessage {
    public EAC_U07() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public EAC_U07(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EQU.class, true, false);
            this.add(EAC_U07_COMMAND.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EAC_U07 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public EQU getEQU() {
        return (EQU)this.getTyped("EQU", EQU.class);
    }

    public EAC_U07_COMMAND getCOMMAND() {
        return (EAC_U07_COMMAND)this.getTyped("COMMAND", EAC_U07_COMMAND.class);
    }

    public EAC_U07_COMMAND getCOMMAND(int rep) {
        return (EAC_U07_COMMAND)this.getTyped("COMMAND", rep, EAC_U07_COMMAND.class);
    }

    public int getCOMMANDReps() {
        return this.getReps("COMMAND");
    }

    public List<EAC_U07_COMMAND> getCOMMANDAll() throws HL7Exception {
        return this.getAllAsList("COMMAND", EAC_U07_COMMAND.class);
    }

    public void insertCOMMAND(EAC_U07_COMMAND structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMAND", (Structure)structure, rep);
    }

    public EAC_U07_COMMAND insertCOMMAND(int rep) throws HL7Exception {
        return (EAC_U07_COMMAND)super.insertRepetition("COMMAND", rep);
    }

    public EAC_U07_COMMAND removeCOMMAND(int rep) throws HL7Exception {
        return (EAC_U07_COMMAND)super.removeRepetition("COMMAND", rep);
    }
}

