/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.EHC_E01_PRODUCT_SERVICE_SECTION;
import ca.uhn.hl7v2.model.v281.segment.AUT;
import ca.uhn.hl7v2.model.v281.segment.CTD;
import ca.uhn.hl7v2.model.v281.segment.IVC;
import ca.uhn.hl7v2.model.v281.segment.LOC;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.model.v281.segment.PYE;
import ca.uhn.hl7v2.model.v281.segment.ROL;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E01
extends AbstractMessage {
    public EHC_E01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public EHC_E01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(IVC.class, true, false);
            this.add(PYE.class, false, false);
            this.add(CTD.class, false, true);
            this.add(AUT.class, false, false);
            this.add(LOC.class, false, true);
            this.add(PRT.class, false, true);
            this.add(ROL.class, false, true);
            this.add(EHC_E01_PRODUCT_SERVICE_SECTION.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return (UAC)this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", (Structure)structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public IVC getIVC() {
        return (IVC)this.getTyped("IVC", IVC.class);
    }

    public PYE getPYE() {
        return (PYE)this.getTyped("PYE", PYE.class);
    }

    public CTD getCTD() {
        return (CTD)this.getTyped("CTD", CTD.class);
    }

    public CTD getCTD(int rep) {
        return (CTD)this.getTyped("CTD", rep, CTD.class);
    }

    public int getCTDReps() {
        return this.getReps("CTD");
    }

    public List<CTD> getCTDAll() throws HL7Exception {
        return this.getAllAsList("CTD", CTD.class);
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", (Structure)structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }

    public AUT getAUT() {
        return (AUT)this.getTyped("AUT", AUT.class);
    }

    public LOC getLOC() {
        return (LOC)this.getTyped("LOC", LOC.class);
    }

    public LOC getLOC(int rep) {
        return (LOC)this.getTyped("LOC", rep, LOC.class);
    }

    public int getLOCReps() {
        return this.getReps("LOC");
    }

    public List<LOC> getLOCAll() throws HL7Exception {
        return this.getAllAsList("LOC", LOC.class);
    }

    public void insertLOC(LOC structure, int rep) throws HL7Exception {
        super.insertRepetition("LOC", (Structure)structure, rep);
    }

    public LOC insertLOC(int rep) throws HL7Exception {
        return (LOC)super.insertRepetition("LOC", rep);
    }

    public LOC removeLOC(int rep) throws HL7Exception {
        return (LOC)super.removeRepetition("LOC", rep);
    }

    public PRT getPRT() {
        return (PRT)this.getTyped("PRT", PRT.class);
    }

    public PRT getPRT(int rep) {
        return (PRT)this.getTyped("PRT", rep, PRT.class);
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ROL getROL() {
        return (ROL)this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return (ROL)this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public EHC_E01_PRODUCT_SERVICE_SECTION getPRODUCT_SERVICE_SECTION() {
        return (EHC_E01_PRODUCT_SERVICE_SECTION)this.getTyped("PRODUCT_SERVICE_SECTION", EHC_E01_PRODUCT_SERVICE_SECTION.class);
    }

    public EHC_E01_PRODUCT_SERVICE_SECTION getPRODUCT_SERVICE_SECTION(int rep) {
        return (EHC_E01_PRODUCT_SERVICE_SECTION)this.getTyped("PRODUCT_SERVICE_SECTION", rep, EHC_E01_PRODUCT_SERVICE_SECTION.class);
    }

    public int getPRODUCT_SERVICE_SECTIONReps() {
        return this.getReps("PRODUCT_SERVICE_SECTION");
    }

    public List<EHC_E01_PRODUCT_SERVICE_SECTION> getPRODUCT_SERVICE_SECTIONAll() throws HL7Exception {
        return this.getAllAsList("PRODUCT_SERVICE_SECTION", EHC_E01_PRODUCT_SERVICE_SECTION.class);
    }

    public void insertPRODUCT_SERVICE_SECTION(EHC_E01_PRODUCT_SERVICE_SECTION structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT_SERVICE_SECTION", (Structure)structure, rep);
    }

    public EHC_E01_PRODUCT_SERVICE_SECTION insertPRODUCT_SERVICE_SECTION(int rep) throws HL7Exception {
        return (EHC_E01_PRODUCT_SERVICE_SECTION)super.insertRepetition("PRODUCT_SERVICE_SECTION", rep);
    }

    public EHC_E01_PRODUCT_SERVICE_SECTION removePRODUCT_SERVICE_SECTION(int rep) throws HL7Exception {
        return (EHC_E01_PRODUCT_SERVICE_SECTION)super.removeRepetition("PRODUCT_SERVICE_SECTION", rep);
    }
}

