/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v281.datatype.CNE;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.SI;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.model.v281.datatype.XAD;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.model.v281.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBX
extends AbstractSegment {
    public OBX(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 0, new Object[]{this.getMessage()}, "Set ID - OBX");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(125)}, "Value Type");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Observation Identifier");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Observation Sub-ID");
            this.add(Varies.class, false, 0, 0, new Object[]{this.getMessage()}, "Observation Value");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Units");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "References Range");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Interpretation Codes");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Probability");
            this.add(ID.class, false, 0, 0, new Object[]{this.getMessage(), new Integer(80)}, "Nature of Abnormal Test");
            this.add(ID.class, true, 1, 0, new Object[]{this.getMessage(), new Integer(85)}, "Observation Result Status");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective Date of Reference Range");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "User Defined Access Checks");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Date/Time of the Observation");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Producer's ID");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Responsible Observer");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Observation Method");
            this.add(EI.class, false, 0, 0, new Object[]{this.getMessage()}, "Equipment Instance Identifier");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Date/Time of the Analysis");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Observation Site");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Observation Instance Identifier");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Mood Code");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Performing Organization Name");
            this.add(XAD.class, false, 1, 0, new Object[]{this.getMessage()}, "Performing Organization Address");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Performing Organization Medical Director");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(909)}, "Patient Results Release Category");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Root Cause");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Local Process Control");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(936)}, "Observation Type");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OBX - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDOBX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObx1_SetIDOBX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getValueType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getObx2_ValueType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getObservationIdentifier() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getObx3_ObservationIdentifier() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getObservationSubID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getObx4_ObservationSubID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public Varies[] getObservationValue() {
        Varies[] retVal = (Varies[])this.getTypedField(5, (Type[])new Varies[0]);
        return retVal;
    }

    public Varies[] getObx5_ObservationValue() {
        Varies[] retVal = (Varies[])this.getTypedField(5, (Type[])new Varies[0]);
        return retVal;
    }

    public int getObservationValueReps() {
        return this.getReps(5);
    }

    public Varies getObservationValue(int rep) {
        Varies retVal = (Varies)this.getTypedField(5, rep);
        return retVal;
    }

    public Varies getObx5_ObservationValue(int rep) {
        Varies retVal = (Varies)this.getTypedField(5, rep);
        return retVal;
    }

    public int getObx5_ObservationValueReps() {
        return this.getReps(5);
    }

    public Varies insertObservationValue(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(5, rep);
    }

    public Varies insertObx5_ObservationValue(int rep) throws HL7Exception {
        return (Varies)super.insertRepetition(5, rep);
    }

    public Varies removeObservationValue(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(5, rep);
    }

    public Varies removeObx5_ObservationValue(int rep) throws HL7Exception {
        return (Varies)super.removeRepetition(5, rep);
    }

    public CWE getUnits() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getObx6_Units() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getReferencesRange() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getObx7_ReferencesRange() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE[] getInterpretationCodes() {
        CWE[] retVal = (CWE[])this.getTypedField(8, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getObx8_InterpretationCodes() {
        CWE[] retVal = (CWE[])this.getTypedField(8, (Type[])new CWE[0]);
        return retVal;
    }

    public int getInterpretationCodesReps() {
        return this.getReps(8);
    }

    public CWE getInterpretationCodes(int rep) {
        CWE retVal = (CWE)this.getTypedField(8, rep);
        return retVal;
    }

    public CWE getObx8_InterpretationCodes(int rep) {
        CWE retVal = (CWE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getObx8_InterpretationCodesReps() {
        return this.getReps(8);
    }

    public CWE insertInterpretationCodes(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(8, rep);
    }

    public CWE insertObx8_InterpretationCodes(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(8, rep);
    }

    public CWE removeInterpretationCodes(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(8, rep);
    }

    public CWE removeObx8_InterpretationCodes(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(8, rep);
    }

    public NM getProbability() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getObx9_Probability() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public ID[] getNatureOfAbnormalTest() {
        ID[] retVal = (ID[])this.getTypedField(10, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getObx10_NatureOfAbnormalTest() {
        ID[] retVal = (ID[])this.getTypedField(10, (Type[])new ID[0]);
        return retVal;
    }

    public int getNatureOfAbnormalTestReps() {
        return this.getReps(10);
    }

    public ID getNatureOfAbnormalTest(int rep) {
        ID retVal = (ID)this.getTypedField(10, rep);
        return retVal;
    }

    public ID getObx10_NatureOfAbnormalTest(int rep) {
        ID retVal = (ID)this.getTypedField(10, rep);
        return retVal;
    }

    public int getObx10_NatureOfAbnormalTestReps() {
        return this.getReps(10);
    }

    public ID insertNatureOfAbnormalTest(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(10, rep);
    }

    public ID insertObx10_NatureOfAbnormalTest(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(10, rep);
    }

    public ID removeNatureOfAbnormalTest(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(10, rep);
    }

    public ID removeObx10_NatureOfAbnormalTest(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(10, rep);
    }

    public ID getObservationResultStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getObx11_ObservationResultStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getEffectiveDateOfReferenceRange() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getObx12_EffectiveDateOfReferenceRange() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getUserDefinedAccessChecks() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getObx13_UserDefinedAccessChecks() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getDateTimeOfTheObservation() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getObx14_DateTimeOfTheObservation() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getProducerSID() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getObx15_ProducerSID() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN[] getResponsibleObserver() {
        XCN[] retVal = (XCN[])this.getTypedField(16, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getObx16_ResponsibleObserver() {
        XCN[] retVal = (XCN[])this.getTypedField(16, (Type[])new XCN[0]);
        return retVal;
    }

    public int getResponsibleObserverReps() {
        return this.getReps(16);
    }

    public XCN getResponsibleObserver(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public XCN getObx16_ResponsibleObserver(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getObx16_ResponsibleObserverReps() {
        return this.getReps(16);
    }

    public XCN insertResponsibleObserver(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN insertObx16_ResponsibleObserver(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN removeResponsibleObserver(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XCN removeObx16_ResponsibleObserver(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public CWE[] getObservationMethod() {
        CWE[] retVal = (CWE[])this.getTypedField(17, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getObx17_ObservationMethod() {
        CWE[] retVal = (CWE[])this.getTypedField(17, (Type[])new CWE[0]);
        return retVal;
    }

    public int getObservationMethodReps() {
        return this.getReps(17);
    }

    public CWE getObservationMethod(int rep) {
        CWE retVal = (CWE)this.getTypedField(17, rep);
        return retVal;
    }

    public CWE getObx17_ObservationMethod(int rep) {
        CWE retVal = (CWE)this.getTypedField(17, rep);
        return retVal;
    }

    public int getObx17_ObservationMethodReps() {
        return this.getReps(17);
    }

    public CWE insertObservationMethod(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(17, rep);
    }

    public CWE insertObx17_ObservationMethod(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(17, rep);
    }

    public CWE removeObservationMethod(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(17, rep);
    }

    public CWE removeObx17_ObservationMethod(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(17, rep);
    }

    public EI[] getEquipmentInstanceIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(18, (Type[])new EI[0]);
        return retVal;
    }

    public EI[] getObx18_EquipmentInstanceIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(18, (Type[])new EI[0]);
        return retVal;
    }

    public int getEquipmentInstanceIdentifierReps() {
        return this.getReps(18);
    }

    public EI getEquipmentInstanceIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(18, rep);
        return retVal;
    }

    public EI getObx18_EquipmentInstanceIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(18, rep);
        return retVal;
    }

    public int getObx18_EquipmentInstanceIdentifierReps() {
        return this.getReps(18);
    }

    public EI insertEquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(18, rep);
    }

    public EI insertObx18_EquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(18, rep);
    }

    public EI removeEquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(18, rep);
    }

    public EI removeObx18_EquipmentInstanceIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(18, rep);
    }

    public DTM getDateTimeOfTheAnalysis() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public DTM getObx19_DateTimeOfTheAnalysis() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE[] getObservationSite() {
        CWE[] retVal = (CWE[])this.getTypedField(20, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getObx20_ObservationSite() {
        CWE[] retVal = (CWE[])this.getTypedField(20, (Type[])new CWE[0]);
        return retVal;
    }

    public int getObservationSiteReps() {
        return this.getReps(20);
    }

    public CWE getObservationSite(int rep) {
        CWE retVal = (CWE)this.getTypedField(20, rep);
        return retVal;
    }

    public CWE getObx20_ObservationSite(int rep) {
        CWE retVal = (CWE)this.getTypedField(20, rep);
        return retVal;
    }

    public int getObx20_ObservationSiteReps() {
        return this.getReps(20);
    }

    public CWE insertObservationSite(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(20, rep);
    }

    public CWE insertObx20_ObservationSite(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(20, rep);
    }

    public CWE removeObservationSite(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(20, rep);
    }

    public CWE removeObx20_ObservationSite(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(20, rep);
    }

    public EI getObservationInstanceIdentifier() {
        EI retVal = (EI)this.getTypedField(21, 0);
        return retVal;
    }

    public EI getObx21_ObservationInstanceIdentifier() {
        EI retVal = (EI)this.getTypedField(21, 0);
        return retVal;
    }

    public CNE getMoodCode() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public CNE getObx22_MoodCode() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public XON getPerformingOrganizationName() {
        XON retVal = (XON)this.getTypedField(23, 0);
        return retVal;
    }

    public XON getObx23_PerformingOrganizationName() {
        XON retVal = (XON)this.getTypedField(23, 0);
        return retVal;
    }

    public XAD getPerformingOrganizationAddress() {
        XAD retVal = (XAD)this.getTypedField(24, 0);
        return retVal;
    }

    public XAD getObx24_PerformingOrganizationAddress() {
        XAD retVal = (XAD)this.getTypedField(24, 0);
        return retVal;
    }

    public XCN getPerformingOrganizationMedicalDirector() {
        XCN retVal = (XCN)this.getTypedField(25, 0);
        return retVal;
    }

    public XCN getObx25_PerformingOrganizationMedicalDirector() {
        XCN retVal = (XCN)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getPatientResultsReleaseCategory() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getObx26_PatientResultsReleaseCategory() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getRootCause() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getObx27_RootCause() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE[] getLocalProcessControl() {
        CWE[] retVal = (CWE[])this.getTypedField(28, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getObx28_LocalProcessControl() {
        CWE[] retVal = (CWE[])this.getTypedField(28, (Type[])new CWE[0]);
        return retVal;
    }

    public int getLocalProcessControlReps() {
        return this.getReps(28);
    }

    public CWE getLocalProcessControl(int rep) {
        CWE retVal = (CWE)this.getTypedField(28, rep);
        return retVal;
    }

    public CWE getObx28_LocalProcessControl(int rep) {
        CWE retVal = (CWE)this.getTypedField(28, rep);
        return retVal;
    }

    public int getObx28_LocalProcessControlReps() {
        return this.getReps(28);
    }

    public CWE insertLocalProcessControl(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(28, rep);
    }

    public CWE insertObx28_LocalProcessControl(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(28, rep);
    }

    public CWE removeLocalProcessControl(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(28, rep);
    }

    public CWE removeObx28_LocalProcessControl(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(28, rep);
    }

    public ID getObservationType() {
        ID retVal = (ID)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getObx29_ObservationType() {
        ID retVal = (ID)this.getTypedField(29, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(125));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new Varies(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(80));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(85));
            }
            case 11: {
                return new DTM(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new DTM(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new EI(this.getMessage());
            }
            case 18: {
                return new DTM(this.getMessage());
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new EI(this.getMessage());
            }
            case 21: {
                return new CNE(this.getMessage());
            }
            case 22: {
                return new XON(this.getMessage());
            }
            case 23: {
                return new XAD(this.getMessage());
            }
            case 24: {
                return new XCN(this.getMessage());
            }
            case 25: {
                return new ID(this.getMessage(), new Integer(909));
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new CWE(this.getMessage());
            }
            case 28: {
                return new ID(this.getMessage(), new Integer(936));
            }
        }
        return null;
    }
}

