/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class QRI
extends AbstractSegment {
    public QRI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Candidate Confidence");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Match Reason Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Algorithm Descriptor");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating QRI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getCandidateConfidence() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getQri1_CandidateConfidence() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getMatchReasonCode() {
        CWE[] retVal = (CWE[])this.getTypedField(2, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getQri2_MatchReasonCode() {
        CWE[] retVal = (CWE[])this.getTypedField(2, (Type[])new CWE[0]);
        return retVal;
    }

    public int getMatchReasonCodeReps() {
        return this.getReps(2);
    }

    public CWE getMatchReasonCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getQri2_MatchReasonCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getQri2_MatchReasonCodeReps() {
        return this.getReps(2);
    }

    public CWE insertMatchReasonCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertQri2_MatchReasonCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeMatchReasonCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removeQri2_MatchReasonCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE getAlgorithmDescriptor() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getQri3_AlgorithmDescriptor() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

