/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax0.license3j.parsers.NumericParser;

public class Feature {
    private static final String[] DATE_FORMAT = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy-MM-dd"};
    private static final int VARIABLE_LENGTH = -1;
    private final String name;
    private final Type type;
    private final byte[] value;

    private Feature(String name, Type type, byte[] value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    private static String dateFormat(Object date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT[0]);
        dateFormat.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        return dateFormat.format(date);
    }

    private static Date dateParse(String date) {
        for (String format : DATE_FORMAT) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                dateFormat.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
                return dateFormat.parse(date);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("Can not parse " + date);
    }

    static String[] splitString(String s) {
        String typeString;
        String name;
        int typeEnd;
        int nameEnd = s.indexOf(":");
        if (nameEnd > (typeEnd = s.indexOf("=", nameEnd + 1))) {
            nameEnd = -1;
        }
        if (typeEnd == -1) {
            throw new IllegalArgumentException("Feature string representation needs '=' after the type");
        }
        if (nameEnd > 0) {
            name = s.substring(0, nameEnd).trim();
            typeString = s.substring(nameEnd + 1, typeEnd).trim();
        } else {
            name = s.substring(0, typeEnd).trim();
            typeString = "STRING";
        }
        String valueString = s.substring(typeEnd + 1);
        return new String[]{name, typeString, valueString};
    }

    static Feature getFeature(String name, String typeString, String valueString) {
        Type type = Type.valueOf(typeString);
        Object value = type.unstringer.apply(valueString);
        return type.factory.apply(name, value);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.toStringWith(this.type.stringer.apply(this.type.objecter.apply(this)));
    }

    String toStringWith(String value) {
        return this.name + (this.type == Type.STRING ? "" : ":" + this.type.toString()) + "=" + value;
    }

    public String valueString() {
        return this.type.stringer.apply(this.type.objecter.apply(this));
    }

    public byte[] serialized() {
        byte[] nameBuffer = this.name.getBytes(StandardCharsets.UTF_8);
        int typeLength = 4;
        int nameLength = 4 + nameBuffer.length;
        int valueLength = 4 + this.value.length;
        ByteBuffer buffer = ByteBuffer.allocate(4 + nameLength + valueLength).putInt(this.type.serialized).putInt(nameBuffer.length);
        if (this.type.fixedSize == -1) {
            buffer.putInt(this.value.length);
        }
        buffer.put(nameBuffer).put(this.value);
        return buffer.array();
    }

    public boolean isBinary() {
        return this.type == Type.BINARY;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isByte() {
        return this.type == Type.BYTE;
    }

    public boolean isShort() {
        return this.type == Type.SHORT;
    }

    public boolean isInt() {
        return this.type == Type.INT;
    }

    public boolean isLong() {
        return this.type == Type.LONG;
    }

    public boolean isFloat() {
        return this.type == Type.FLOAT;
    }

    public boolean isDouble() {
        return this.type == Type.DOUBLE;
    }

    public boolean isBigInteger() {
        return this.type == Type.BIGINTEGER;
    }

    public boolean isBigDecimal() {
        return this.type == Type.BIGDECIMAL;
    }

    public boolean isDate() {
        return this.type == Type.DATE;
    }

    public boolean isUUID() {
        return this.type == Type.UUID;
    }

    public byte[] getBinary() {
        if (this.type != Type.BINARY) {
            throw new IllegalArgumentException("Feature is not BINARY");
        }
        return this.value;
    }

    public String getString() {
        if (this.type != Type.STRING) {
            throw new IllegalArgumentException("Feature is not STRING");
        }
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public byte getByte() {
        if (this.type != Type.BYTE) {
            throw new IllegalArgumentException("Feature is not BYTE");
        }
        return this.value[0];
    }

    public short getShort() {
        if (this.type != Type.SHORT) {
            throw new IllegalArgumentException("Feature is not SHORT");
        }
        return ByteBuffer.wrap(this.value).getShort();
    }

    public int getInt() {
        if (this.type != Type.INT) {
            throw new IllegalArgumentException("Feature is not INT");
        }
        return ByteBuffer.wrap(this.value).getInt();
    }

    public long getLong() {
        if (this.type != Type.LONG) {
            throw new IllegalArgumentException("Feature is not LONG");
        }
        return ByteBuffer.wrap(this.value).getLong();
    }

    public float getFloat() {
        if (this.type != Type.FLOAT) {
            throw new IllegalArgumentException("Feature is not FLOAT");
        }
        return ByteBuffer.wrap(this.value).getFloat();
    }

    public double getDouble() {
        if (this.type != Type.DOUBLE) {
            throw new IllegalArgumentException("Feature is not DOUBLE");
        }
        return ByteBuffer.wrap(this.value).getDouble();
    }

    public BigInteger getBigInteger() {
        if (this.type != Type.BIGINTEGER) {
            throw new IllegalArgumentException("Feature is not BIGINTEGER");
        }
        return new BigInteger(this.value);
    }

    public BigDecimal getBigDecimal() {
        if (this.type != Type.BIGDECIMAL) {
            throw new IllegalArgumentException("Feature is not BIGDECIMAL");
        }
        ByteBuffer bb = ByteBuffer.wrap(this.value);
        int scale = bb.getInt(this.value.length - 4);
        return new BigDecimal(new BigInteger(Arrays.copyOf(this.value, this.value.length - 4)), scale);
    }

    public UUID getUUID() {
        if (this.type != Type.UUID) {
            throw new IllegalArgumentException("Feature is not UUID");
        }
        ByteBuffer bb = ByteBuffer.wrap(this.value);
        long ls = bb.getLong();
        long ms = bb.getLong();
        return new UUID(ms, ls);
    }

    public Date getDate() {
        if (this.type != Type.DATE) {
            throw new IllegalArgumentException("Feature is not DATE");
        }
        return new Date(ByteBuffer.wrap(this.value).getLong());
    }

    public static class Create {
        private Create() {
        }

        private static void notNull(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot create a feature from null value.");
            }
        }

        public static Feature binaryFeature(String name, byte[] value) {
            Create.notNull(value);
            return new Feature(name, Type.BINARY, value);
        }

        public static Feature stringFeature(String name, String value) {
            Create.notNull(value);
            return new Feature(name, Type.STRING, value.getBytes(StandardCharsets.UTF_8));
        }

        public static Feature byteFeature(String name, Byte value) {
            Create.notNull(value);
            return new Feature(name, Type.BYTE, new byte[]{value});
        }

        public static Feature shortFeature(String name, Short value) {
            Create.notNull(value);
            return new Feature(name, Type.SHORT, ByteBuffer.allocate(2).putShort(value).array());
        }

        public static Feature intFeature(String name, Integer value) {
            Create.notNull(value);
            return new Feature(name, Type.INT, ByteBuffer.allocate(4).putInt(value).array());
        }

        public static Feature longFeature(String name, Long value) {
            Create.notNull(value);
            return new Feature(name, Type.LONG, ByteBuffer.allocate(8).putLong(value).array());
        }

        public static Feature floatFeature(String name, Float value) {
            Create.notNull(value);
            return new Feature(name, Type.FLOAT, ByteBuffer.allocate(4).putFloat(value.floatValue()).array());
        }

        public static Feature doubleFeature(String name, Double value) {
            Create.notNull(value);
            return new Feature(name, Type.DOUBLE, ByteBuffer.allocate(8).putDouble(value).array());
        }

        public static Feature bigIntegerFeature(String name, BigInteger value) {
            Create.notNull(value);
            return new Feature(name, Type.BIGINTEGER, value.toByteArray());
        }

        public static Feature bigDecimalFeature(String name, BigDecimal value) {
            Create.notNull(value);
            byte[] b = value.unscaledValue().toByteArray();
            return new Feature(name, Type.BIGDECIMAL, ByteBuffer.allocate(4 + b.length).put(b).putInt(value.scale()).array());
        }

        public static Feature uuidFeature(String name, UUID value) {
            Create.notNull(value);
            return new Feature(name, Type.UUID, ByteBuffer.allocate(16).putLong(value.getLeastSignificantBits()).putLong(value.getMostSignificantBits()).array());
        }

        public static Feature dateFeature(String name, Date value) {
            Create.notNull(value);
            return new Feature(name, Type.DATE, ByteBuffer.allocate(8).putLong(value.getTime()).array());
        }

        public static Feature from(String s) {
            String[] parts = Feature.splitString(s);
            return Feature.getFeature(parts[0], parts[1], parts[2]);
        }

        public static Feature from(byte[] serialized) {
            int nameLength;
            if (serialized.length < 12) {
                throw new IllegalArgumentException("Cannot load feature from a byte array that has " + serialized.length + " bytes which is < " + 12);
            }
            ByteBuffer bb = ByteBuffer.wrap(serialized);
            int typeSerialized = bb.getInt();
            Type type = Create.typeFrom(typeSerialized);
            int valueLength = type.fixedSize == -1 ? bb.getInt() : type.fixedSize;
            int expectedLength = 12 + valueLength + (nameLength = bb.getInt());
            if (serialized.length != expectedLength) {
                throw new IllegalArgumentException("Cannot load feature from a byte array that has " + serialized.length + " bytes which is != " + expectedLength);
            }
            byte[] nameBuffer = new byte[nameLength];
            bb.get(nameBuffer);
            byte[] value = new byte[valueLength];
            if (valueLength > 0) {
                bb.get(value);
            }
            String name = new String(nameBuffer, StandardCharsets.UTF_8);
            return new Feature(name, type, value);
        }

        private static Type typeFrom(int typeSerialized) {
            for (Type type : Type.values()) {
                if (type.serialized != typeSerialized) continue;
                return type;
            }
            throw new IllegalArgumentException("The deserialized form has a type value " + typeSerialized + " which is not valid.");
        }
    }

    private static enum Type {
        BINARY(1, -1, Feature::getBinary, (name, value) -> Create.binaryFeature(name, (byte[])value), ba -> Base64.getEncoder().encodeToString((byte[])ba), enc -> Base64.getDecoder().decode((String)enc)),
        STRING(2, -1, Feature::getString, (name, value) -> Create.stringFeature(name, (String)value), Object::toString, s -> s),
        BYTE(3, 1, Feature::getByte, (name, value) -> Create.byteFeature(name, (Byte)value), b -> String.format("0x%02X", (byte)((Byte)b)), NumericParser.Byte::parse),
        SHORT(4, 2, Feature::getShort, (name, value) -> Create.shortFeature(name, (Short)value), Object::toString, NumericParser.Short::parse),
        INT(5, 4, Feature::getInt, (name, value) -> Create.intFeature(name, (Integer)value), Object::toString, NumericParser.Int::parse),
        LONG(6, 8, Feature::getLong, (name, value) -> Create.longFeature(name, (Long)value), Object::toString, NumericParser.Long::parse),
        FLOAT(7, 4, Feature::getFloat, (name, value) -> Create.floatFeature(name, (Float)value), Object::toString, Float::parseFloat),
        DOUBLE(8, 8, Feature::getDouble, (name, value) -> Create.doubleFeature(name, (Double)value), Object::toString, Double::parseDouble),
        BIGINTEGER(9, -1, Feature::getBigInteger, (name, value) -> Create.bigIntegerFeature(name, (BigInteger)value), Object::toString, BigInteger::new),
        BIGDECIMAL(10, -1, Feature::getBigDecimal, (name, value) -> Create.bigDecimalFeature(name, (BigDecimal)value), Object::toString, BigDecimal::new),
        DATE(11, 8, Feature::getDate, (name, value) -> Create.dateFeature(name, (Date)value), x$0 -> Feature.access$100(x$0), x$0 -> Feature.access$000(x$0)),
        UUID(12, 16, Feature::getUUID, (name, value) -> Create.uuidFeature(name, (UUID)value), Object::toString, UUID::fromString);

        final int fixedSize;
        final int serialized;
        final Function<Object, String> stringer;
        final Function<Feature, Object> objecter;
        final Function<String, Object> unstringer;
        final BiFunction<String, Object, Feature> factory;

        private Type(int serialized, int fixedSize, Function<Feature, Object> objecter, BiFunction<String, Object, Feature> factory, Function<Object, String> toStringer, Function<String, Object> unstringer) {
            this.serialized = serialized;
            this.fixedSize = fixedSize;
            this.stringer = toStringer;
            this.objecter = objecter;
            this.unstringer = unstringer;
            this.factory = factory;
        }
    }
}

