/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.hardware;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax0.license3j.hardware.HashCalculator;
import javax0.license3j.hardware.Network;

public class UUIDCalculator {
    private final HashCalculator calculator;

    public UUIDCalculator(Network.Interface.Selector selector) {
        this.calculator = new HashCalculator(selector);
    }

    public UUID getMachineId(boolean useNetwork, boolean useHostName, boolean useArchitecture) throws SocketException, UnknownHostException, NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        if (useNetwork) {
            this.calculator.updateWithNetworkData(md5);
        }
        if (useHostName) {
            this.calculator.updateWithHostName(md5);
        }
        if (useArchitecture) {
            this.calculator.updateWithArchitecture(md5);
        }
        byte[] digest = md5.digest();
        return UUID.nameUUIDFromBytes(digest);
    }

    public String getMachineIdString(boolean useNetwork, boolean useHostName, boolean useArchitecture) throws SocketException, UnknownHostException, NoSuchAlgorithmException {
        UUID uuid = this.getMachineId(useNetwork, useHostName, useArchitecture);
        if (uuid != null) {
            return uuid.toString();
        }
        return null;
    }

    public boolean assertUUID(UUID uuid, boolean useNetwork, boolean useHostName, boolean useArchitecture) throws SocketException, UnknownHostException, NoSuchAlgorithmException {
        UUID machineUUID = this.getMachineId(useNetwork, useHostName, useArchitecture);
        return machineUUID != null && machineUUID.equals(uuid);
    }

    public boolean assertUUID(String uuid, boolean useNetwork, boolean useHostName, boolean useArchitecture) {
        try {
            return this.assertUUID(UUID.fromString(uuid), useNetwork, useHostName, useArchitecture);
        }
        catch (Exception e) {
            return false;
        }
    }
}

