/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax0.license3j.crypto.LicenseKeyPair;
import javax0.license3j.io.ByteArrayReader;
import javax0.license3j.io.IOFormat;

public class KeyPairReader
implements Closeable {
    private final InputStream is;

    public KeyPairReader(InputStream is) {
        this.is = is;
    }

    public KeyPairReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public KeyPairReader(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public LicenseKeyPair readPublic() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.readPublic(IOFormat.BINARY);
    }

    public LicenseKeyPair readPublic(IOFormat format) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.read(format, 1);
    }

    public LicenseKeyPair readPrivate() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.readPrivate(IOFormat.BINARY);
    }

    public LicenseKeyPair readPrivate(IOFormat format) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return this.read(format, 2);
    }

    private LicenseKeyPair read(IOFormat format, int type) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        switch (format) {
            case BINARY: {
                return LicenseKeyPair.Create.from(ByteArrayReader.readInput(this.is), type);
            }
            case BASE64: {
                return LicenseKeyPair.Create.from(Base64.getDecoder().decode(ByteArrayReader.readInput(this.is)), type);
            }
        }
        throw new IllegalArgumentException("License format " + (Object)((Object)format) + " is unknown.");
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }
}

