/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax0.license3j.License;
import javax0.license3j.io.ByteArrayReader;
import javax0.license3j.io.IOFormat;

public class LicenseReader
implements Closeable {
    private final InputStream is;

    public LicenseReader(InputStream is) {
        this.is = is;
    }

    public LicenseReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public LicenseReader(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public License read() throws IOException {
        return this.read(IOFormat.BINARY);
    }

    public License read(IOFormat format) throws IOException {
        switch (format) {
            case BINARY: {
                return License.Create.from(ByteArrayReader.readInput(this.is));
            }
            case BASE64: {
                return License.Create.from(Base64.getDecoder().decode(ByteArrayReader.readInput(this.is)));
            }
            case STRING: {
                return License.Create.from(new String(ByteArrayReader.readInput(this.is), StandardCharsets.UTF_8));
            }
        }
        throw new IllegalArgumentException("License format " + (Object)((Object)format) + " is unknown.");
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }
}

