/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchIndex;
import com.algolia.search.exceptions.AlgoliaApiException;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.iterators.IndexIterable;
import com.algolia.search.iterators.RulesIterable;
import com.algolia.search.iterators.SynonymsIterable;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.WaitableResponse;
import com.algolia.search.models.indexing.BatchIndexingResponse;
import com.algolia.search.models.indexing.MultiResponse;
import com.algolia.search.models.rules.SaveRuleResponse;
import com.algolia.search.models.settings.IndexSettings;
import com.algolia.search.models.synonyms.SaveSynonymResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class AccountClient {
    public static <T> MultiResponse copyIndex(@Nonnull SearchIndex<T> sourceIndex, @Nonnull SearchIndex<T> destinationIndex) {
        return LaunderThrowable.await(AccountClient.copyIndexAsync(sourceIndex, destinationIndex));
    }

    public static <T> MultiResponse copyIndex(@Nonnull SearchIndex<T> sourceIndex, @Nonnull SearchIndex<T> destinationIndex, RequestOptions requestOptions) {
        return LaunderThrowable.await(AccountClient.copyIndexAsync(sourceIndex, destinationIndex, requestOptions));
    }

    public static <T> CompletableFuture<MultiResponse> copyIndexAsync(@Nonnull SearchIndex<T> sourceIndex, @Nonnull SearchIndex<T> destinationIndex) {
        return AccountClient.copyIndexAsync(sourceIndex, destinationIndex, null);
    }

    public static <T> CompletableFuture<MultiResponse> copyIndexAsync(@Nonnull SearchIndex<T> sourceIndex, @Nonnull SearchIndex<T> destinationIndex, RequestOptions requestOptions) {
        block4: {
            Objects.requireNonNull(sourceIndex, "A source index is required");
            Objects.requireNonNull(destinationIndex, "A destination index is required");
            if (sourceIndex.getConfig().getApplicationID().equals(destinationIndex.getConfig().getApplicationID())) {
                throw new AlgoliaRuntimeException("Source and Destination indices should not be on the same application.");
            }
            try {
                IndexSettings destinationSettings = destinationIndex.getSettings(requestOptions);
                if (destinationSettings != null) {
                    throw new AlgoliaRuntimeException("Destination index should not exist. Make sure the destination index does not exist or copy to another index.");
                }
            }
            catch (AlgoliaApiException ex) {
                if (ex.getHttpErrorCode() == 404) break block4;
                throw ex;
            }
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        CompletionStage destinationSettingsFuture = sourceIndex.getSettingsAsync(requestOptions).thenComposeAsync(r -> destinationIndex.setSettingsAsync((IndexSettings)r, requestOptions));
        futures.add(destinationSettingsFuture);
        SynonymsIterable sourceSynonyms = new SynonymsIterable(sourceIndex);
        CompletableFuture<SaveSynonymResponse> destinationSynonymsFuture = destinationIndex.saveSynonymsAsync(sourceSynonyms, requestOptions);
        futures.add(destinationSynonymsFuture);
        RulesIterable sourceRules = new RulesIterable(sourceIndex);
        CompletableFuture<SaveRuleResponse> destinationRulesFuture = destinationIndex.saveRulesAsync(sourceRules, requestOptions);
        futures.add(destinationRulesFuture);
        IndexIterable<T> sourceObjects = new IndexIterable<T>(sourceIndex);
        CompletableFuture<BatchIndexingResponse> destinationSaveObjects = destinationIndex.saveObjectsAsync(sourceObjects, requestOptions);
        futures.add(destinationSaveObjects);
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenComposeAsync(v -> {
            List<WaitableResponse> resp = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
            return CompletableFuture.completedFuture(new MultiResponse().setResponses(resp));
        });
    }
}

