/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchIndex;
import com.algolia.search.SearchIndexBase;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.iterators.SynonymsIterable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.indexing.DeleteResponse;
import com.algolia.search.models.indexing.SearchResult;
import com.algolia.search.models.synonyms.ClearSynonymsResponse;
import com.algolia.search.models.synonyms.SaveSynonymResponse;
import com.algolia.search.models.synonyms.Synonym;
import com.algolia.search.models.synonyms.SynonymQuery;
import com.algolia.search.util.AlgoliaUtils;
import com.algolia.search.util.QueryStringUtils;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public interface SearchIndexSynonyms<T>
extends SearchIndexBase<T> {
    default public SearchResult<Synonym> searchSynonyms(SynonymQuery query) {
        return LaunderThrowable.await(this.searchSynonymsAsync(query, null));
    }

    default public SearchResult<Synonym> searchSynonyms(SynonymQuery query, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.searchSynonymsAsync(query, requestOptions));
    }

    default public CompletableFuture<SearchResult<Synonym>> searchSynonymsAsync(SynonymQuery query) {
        return this.searchSynonymsAsync(query, null);
    }

    default public CompletableFuture<SearchResult<Synonym>> searchSynonymsAsync(SynonymQuery query, RequestOptions requestOptions) {
        Objects.requireNonNull(query, "A query is required.");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.getUrlEncodedIndexName() + "/synonyms/search", CallType.READ, query, SearchResult.class, Synonym.class, requestOptions).thenComposeAsync(resp -> {
            CompletableFuture<SearchResult> r = new CompletableFuture<SearchResult>();
            r.complete((SearchResult)resp);
            return r;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public Synonym getSynonym(@Nonnull String objectID) {
        return LaunderThrowable.await(this.getSynonymAsync(objectID));
    }

    default public Synonym getSynonym(@Nonnull String objectID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getSynonymAsync(objectID, requestOptions));
    }

    default public CompletableFuture<Synonym> getSynonymAsync(@Nonnull String objectID) {
        return this.getSynonymAsync(objectID, null);
    }

    default public CompletableFuture<Synonym> getSynonymAsync(@Nonnull String objectID, RequestOptions requestOptions) {
        Objects.requireNonNull(objectID, "The synonym ID is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(objectID).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty or white spaces.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/indexes/" + this.getUrlEncodedIndexName() + "/synonyms/" + objectID, CallType.READ, Synonym.class, requestOptions);
    }

    default public SynonymsIterable browseSynonyms() {
        return this.browseSynonyms(1000, null);
    }

    default public SynonymsIterable browseSynonyms(int hitsPerPage) {
        return this.browseSynonyms(hitsPerPage, null);
    }

    default public SynonymsIterable browseSynonyms(int hitsPerPage, RequestOptions requestOptions) {
        return new SynonymsIterable((SearchIndex)this, hitsPerPage, requestOptions);
    }

    default public SaveSynonymResponse saveSynonym(@Nonnull Synonym synonym) {
        return LaunderThrowable.await(this.saveSynonymAsync(synonym));
    }

    default public SaveSynonymResponse saveSynonym(@Nonnull Synonym synonym, @Nonnull Boolean forwardToReplicas) {
        return LaunderThrowable.await(this.saveSynonymAsync(synonym, forwardToReplicas));
    }

    default public SaveSynonymResponse saveSynonym(@Nonnull Synonym synonym, @Nonnull Boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveSynonymAsync(synonym, forwardToReplicas, requestOptions));
    }

    default public SaveSynonymResponse saveSynonym(@Nonnull Synonym synonym, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveSynonymAsync(synonym, requestOptions));
    }

    default public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(@Nonnull Synonym synonym) {
        return this.saveSynonymAsync(synonym, false, new RequestOptions());
    }

    default public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(@Nonnull Synonym synonym, @Nonnull Boolean forwardToReplicas) {
        return this.saveSynonymAsync(synonym, forwardToReplicas, new RequestOptions());
    }

    default public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(@Nonnull Synonym synonym, @Nonnull Boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        Objects.requireNonNull(requestOptions, "RequestOptions are required.");
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        requestOptions.addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString());
        return this.saveSynonymAsync(synonym, requestOptions);
    }

    default public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(@Nonnull Synonym synonym, @Nonnull RequestOptions requestOptions) {
        Objects.requireNonNull(synonym, "A synonym is required.");
        Objects.requireNonNull(requestOptions, "RequestOptions are required.");
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(synonym.getObjectID()).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be null, empty or white spaces.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.PUT, "/1/indexes/" + this.getUrlEncodedIndexName() + "/synonyms/" + synonym.getObjectID(), CallType.WRITE, synonym, SaveSynonymResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public SaveSynonymResponse saveSynonyms(@Nonnull Iterable<Synonym> synonyms) {
        return LaunderThrowable.await(this.saveSynonymsAsync(synonyms));
    }

    default public SaveSynonymResponse saveSynonyms(@Nonnull Iterable<Synonym> synonyms, @Nonnull Boolean forwardToReplicas, @Nonnull Boolean clearExistingSynonyms) {
        return LaunderThrowable.await(this.saveSynonymsAsync(synonyms, forwardToReplicas, clearExistingSynonyms));
    }

    default public SaveSynonymResponse saveSynonyms(@Nonnull Iterable<Synonym> synonyms, @Nonnull Boolean forwardToReplicas, @Nonnull Boolean clearExistingSynonyms, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveSynonymsAsync(synonyms, forwardToReplicas, clearExistingSynonyms, requestOptions));
    }

    default public SaveSynonymResponse saveSynonyms(@Nonnull Iterable<Synonym> synonyms, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveSynonymsAsync(synonyms, requestOptions));
    }

    default public CompletableFuture<SaveSynonymResponse> saveSynonymsAsync(@Nonnull Iterable<Synonym> synonyms) {
        return this.saveSynonymsAsync(synonyms, false, false, new RequestOptions());
    }

    default public CompletableFuture<SaveSynonymResponse> saveSynonymsAsync(@Nonnull Iterable<Synonym> synonyms, @Nonnull Boolean forwardToReplicas, @Nonnull Boolean clearExistingSynonyms) {
        return this.saveSynonymsAsync(synonyms, forwardToReplicas, clearExistingSynonyms, new RequestOptions());
    }

    default public CompletableFuture<SaveSynonymResponse> saveSynonymsAsync(@Nonnull Iterable<Synonym> synonyms, @Nonnull Boolean forwardToReplicas, @Nonnull Boolean clearExistingSynonyms, @Nonnull RequestOptions requestOptions) {
        Objects.requireNonNull(requestOptions, "RequestOptions are required.");
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        Objects.requireNonNull(clearExistingSynonyms, "clearExistingSynonyms is required.");
        requestOptions.addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString()).addExtraQueryParameters("replaceExistingSynonyms", clearExistingSynonyms.toString());
        return this.saveSynonymsAsync(synonyms, requestOptions);
    }

    default public CompletableFuture<SaveSynonymResponse> saveSynonymsAsync(@Nonnull Iterable<Synonym> synonyms, RequestOptions requestOptions) {
        Objects.requireNonNull(synonyms, "synonyms are required.");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.getUrlEncodedIndexName() + "/synonyms/batch", CallType.WRITE, synonyms, SaveSynonymResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public DeleteResponse deleteSynonym(@Nonnull String objectID) {
        return LaunderThrowable.await(this.deleteSynonymAsync(objectID));
    }

    default public DeleteResponse deleteSynonym(@Nonnull String objectID, @Nonnull Boolean forwardToReplicas) {
        return LaunderThrowable.await(this.deleteSynonymAsync(objectID, forwardToReplicas));
    }

    default public DeleteResponse deleteSynonym(@Nonnull String objectID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteSynonymAsync(objectID, requestOptions));
    }

    default public CompletableFuture<DeleteResponse> deleteSynonymAsync(@Nonnull String objectID) {
        return this.deleteSynonymAsync(objectID, false);
    }

    default public CompletableFuture<DeleteResponse> deleteSynonymAsync(@Nonnull String objectID, @Nonnull Boolean forwardToReplicas) {
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        RequestOptions requestOptions = new RequestOptions().addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString());
        return this.deleteSynonymAsync(objectID, requestOptions);
    }

    default public CompletableFuture<DeleteResponse> deleteSynonymAsync(@Nonnull String objectID, RequestOptions requestOptions) {
        Objects.requireNonNull(objectID, "The objectID is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(objectID).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty or white spaces.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.DELETE, "/1/indexes/" + this.getUrlEncodedIndexName() + "/synonyms/" + QueryStringUtils.urlEncodeUTF8(objectID), CallType.WRITE, DeleteResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public ClearSynonymsResponse clearSynonyms() {
        return LaunderThrowable.await(this.clearSynonymsAsync());
    }

    default public ClearSynonymsResponse clearSynonyms(@Nonnull Boolean forwardToReplicas) {
        return LaunderThrowable.await(this.clearSynonymsAsync(forwardToReplicas));
    }

    default public ClearSynonymsResponse clearSynonyms(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.clearSynonymsAsync(requestOptions));
    }

    default public CompletableFuture<ClearSynonymsResponse> clearSynonymsAsync() {
        return this.clearSynonymsAsync(new RequestOptions());
    }

    default public CompletableFuture<ClearSynonymsResponse> clearSynonymsAsync(@Nonnull Boolean forwardToReplicas) {
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        RequestOptions requestOptions = new RequestOptions().addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString());
        return this.clearSynonymsAsync(requestOptions);
    }

    default public CompletableFuture<ClearSynonymsResponse> clearSynonymsAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.getUrlEncodedIndexName() + "/synonyms/clear", CallType.WRITE, ClearSynonymsResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public SaveSynonymResponse replaceAllSynonyms(@Nonnull Iterable<Synonym> synonyms) {
        return LaunderThrowable.await(this.replaceAllSynonymsAsync(synonyms));
    }

    default public SaveSynonymResponse replaceAllSynonyms(@Nonnull Iterable<Synonym> synonyms, @Nonnull Boolean forwardToReplicas) {
        return LaunderThrowable.await(this.replaceAllSynonymsAsync(synonyms, forwardToReplicas));
    }

    default public SaveSynonymResponse replaceAllSynonyms(@Nonnull Iterable<Synonym> synonyms, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.replaceAllSynonymsAsync(synonyms, requestOptions));
    }

    default public CompletableFuture<SaveSynonymResponse> replaceAllSynonymsAsync(@Nonnull Iterable<Synonym> synonyms) {
        return this.saveSynonymsAsync(synonyms, false, true, new RequestOptions());
    }

    default public CompletableFuture<SaveSynonymResponse> replaceAllSynonymsAsync(@Nonnull Iterable<Synonym> synonyms, @Nonnull Boolean forwardToReplicas) {
        return this.saveSynonymsAsync(synonyms, forwardToReplicas, true, new RequestOptions());
    }

    default public CompletableFuture<SaveSynonymResponse> replaceAllSynonymsAsync(@Nonnull Iterable<Synonym> synonyms, @Nonnull RequestOptions requestOptions) {
        return this.saveSynonymsAsync(synonyms, false, true, requestOptions);
    }
}

