/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.indexing;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import javax.annotation.Nonnull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BatchOperation<T>
implements Serializable {
    private String action;
    private String indexName;
    private T body;

    public static <T> BatchOperation<T> createAddObject(@Nonnull T body) {
        return new BatchOperation<T>("addObject", body);
    }

    public static <T> BatchOperation<T> createUpdateObject(@Nonnull T body) {
        return new BatchOperation<T>("updateObject", body);
    }

    public static <T> BatchOperation<T> createPartialUpdateObject(@Nonnull T body) {
        return new BatchOperation<T>("partialUpdateObject", body);
    }

    public static <T> BatchOperation<T> createPartialUpdateObjectNoCreate(@Nonnull T body) {
        return new BatchOperation<T>("partialUpdateObjectNoCreate", body);
    }

    public static <T> BatchOperation<T> createDeleteObject(@Nonnull T body) {
        return new BatchOperation<T>("deleteObject", body);
    }

    public static <T> BatchOperation<T> createDelete(@Nonnull T body) {
        return new BatchOperation<T>("delete", body);
    }

    public BatchOperation(String indexName, String action, T body) {
        this.action = action;
        this.indexName = indexName;
        this.body = body;
    }

    public BatchOperation(String indexName, String action) {
        this.action = action;
        this.indexName = indexName;
    }

    public BatchOperation(String action, T body) {
        this.action = action;
        this.body = body;
    }

    public String getAction() {
        return this.action;
    }

    public BatchOperation<T> setAction(String action) {
        this.action = action;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public BatchOperation<T> setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public BatchOperation<T> setBody(T body) {
        this.body = body;
        return this;
    }
}

