/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.plaf.basic.BasicBusyLabelUI;

public class FlatBusyLabelUI
extends BasicBusyLabelUI {
    private Color disabledForeground;

    public static ComponentUI createUI(JComponent c) {
        return new FlatBusyLabelUI((JXBusyLabel)c);
    }

    public FlatBusyLabelUI(JXBusyLabel busyLabel) {
        super(busyLabel);
    }

    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        this.disabledForeground = UIManager.getColor("Label.disabledForeground");
        if (c.getIcon() != null) {
            JXBusyLabel busyLabel = (JXBusyLabel)c;
            boolean oldBusy = busyLabel.isBusy();
            busyLabel.setBusy(false);
            busyLabel.setBusyPainter(null);
            busyLabel.setBusy(oldBusy);
        }
    }

    protected void uninstallDefaults(JLabel c) {
        super.uninstallDefaults(c);
        this.disabledForeground = null;
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = FlatLaf.isShowMnemonics() ? l.getDisplayedMnemonicIndex() : -1;
        g.setColor(this.disabledForeground);
        FlatUIUtils.drawStringUnderlineCharAt((JComponent)l, (Graphics)g, (String)s, (int)mnemIndex, (int)textX, (int)textY);
    }
}

