/*
 * Decompiled with CFR 0.152.
 */
package webapp.runner.launch;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.catalina.Context;
import ru.zinin.redis.session.RedisManager;
import webapp.runner.launch.CommandLineParams;
import webapp.runner.launch.SessionStore;

public class RedisSessionStore
extends SessionStore {
    @Override
    public void configureSessionStore(CommandLineParams commandLineParams, Context ctx) {
        RedisManager redisManager = new RedisManager();
        redisManager.setDisableListeners(true);
        if (System.getenv("REDIS_URL") == null && System.getenv("REDISTOGO_URL") == null && System.getenv("REDISCLOUD_URL") == null) {
            System.out.println("WARNING: redis session store being used, but the required environment variable isn't set.");
            System.out.println("Redis session store is configured with REDIS_URL, REDISTOGO_URL or REDISCLOUD_URL");
        } else {
            try {
                URI redisUri = System.getenv("REDIS_URL") != null ? new URI(System.getenv("REDIS_URL")) : (System.getenv("REDISTOGO_URL") != null ? new URI(System.getenv("REDISTOGO_URL")) : new URI(System.getenv("REDISCLOUD_URL")));
                if (redisUri.getHost() != null) {
                    redisManager.setRedisHostname(redisUri.getHost());
                }
                if (redisUri.getPort() != -1) {
                    redisManager.setRedisPort(redisUri.getPort());
                }
                if (redisUri.getUserInfo() != null) {
                    redisManager.setRedisPassword(redisUri.getUserInfo().substring(redisUri.getUserInfo().indexOf(":") + 1));
                }
            }
            catch (URISyntaxException e) {
                System.out.println("WARNING: redis session store environment variable invalid " + System.getenv("REDIS_URL"));
            }
        }
        ctx.setManager(redisManager);
    }
}

