package org.ocap.dvr.storage;

import org.ocap.storage.StorageManagerEvent;
import org.ocap.shared.dvr.navigation.RecordingList;

/**
 * This interface SHALL be implemented by <code>StorageManagerEvent</code>s
 * generated by the implementation that involve a <code>StorageProxy</code>
 * which contains <code>MediaStorageVolume</code>s.
 */
public interface MediaStorageEvent
{
    /**
     * Returns the list of scheduled, pending, in-progress, and completed 
     * recordings for which a contained <code>MediaStorageVolume</code> is
     * an explicit or implicit destination.
     * <p>
     * Note that this may include recordings which no longer exist (in the
     * case of a {@link StorageManagerEvent#STORAGE_PROXY_REMOVED delete}) 
     * or recordings that previously did not exist (in the case of an 
     * {@link StorageManagerEvent#STORAGE_PROXY_ADDED add}).
     *
     * @return the list of recordings affected by this event.
     */
    public RecordingList getEntries();
}
