package org.ocap.shared.dvr;

import java.util.EventListener;

/**
 * Listener to receive changes in the recording list maintained by the
 * RecordingManager.
 */
public interface RecordingChangedListener extends EventListener
{

    /**
     * Notifies the <code>RecordingChangedListener</code> of an event
     * generated by the <code>RecordingManager</code>. Events are
     * generated when there are changes in the list of recording
     * requests maintained by the recording manager.
     *
     * @param e The generated event.
     */
    public void recordingChanged(RecordingChangedEvent e);

}


