package org.ocap.shared.dvr;

import javax.tv.service.selection.ServiceContext;
import javax.tv.service.selection.ServiceContextEvent;

/**
 * An Event Notifying that recording has terminated for the
 * <code>ServiceContext</code>.  This event is generated by a
 * <code>ServiceContext</code> that is presenting a time-shifted service
 * or a service that is being recorded.  The presentation is not yet
 * terminated as the playback point is time-delayed.  This event is
 * generated only when the playback point is not the same as the live
 * point.  A <code>PresentationTerminatedEvent</code> will be generated
 * when the playback point catches up with the point of record termination.
 */
public class RecordingTerminatedEvent extends ServiceContextEvent
{

    /**
     * Reason code: The service vanished from the network.
     */
    public static final int SERVICE_VANISHED = 1;

    /**
     * Reason code: Resources needed to record the service have been removed.
     * Will be generated if the {@link ServiceContext} stop method is called.
     */
    public static final int RESOURCES_REMOVED = 2;

    /**
     * Reason code: Access to the service or some component of it has been
     *  withdrawn by the system. An example of this is the end of a free
     *  preview period for IPPV content.
     */
    public static final int ACCESS_WITHDRAWN = 3;

    /**
     * Reason code: The recording was terminated normally as scheduled.
     */
    public static final int SCHEDULED_STOP = 4;

    /**
     * Reason code: The user requested that the recording be stopped.  Also,
     * if the {@link RecordingRequest} stop method is called.
     */
    public static final int USER_STOP = 5;

    /**
     * Constructs the event.
     *
     * @param source The <code>ServiceContext</code> that
     *      generated the event.
     * @param reason The reason the recording terminated
     */
    public RecordingTerminatedEvent(ServiceContext source, int reason)
    {
        super(source);
    }

    /**
     * Returns the reason for the recordings termination.
     *
     * @return Termination reason; see constants in this class.
     */
    public int getReason()
    {
        return 0;
    }

}


